/*
 * Decompiled with CFR 0.152.
 */
package playn.core.json;

import java.math.BigInteger;
import playn.core.json.JsonArray;
import playn.core.json.JsonObject;
import playn.core.json.JsonParserException;

final class JsonParser {
    private int linePos = 1;
    private int rowPos;
    private int charOffset;
    private int utf8adjust;
    private int tokenLinePos;
    private int tokenCharPos;
    private int tokenCharOffset;
    private Object value;
    private Token token;
    private StringBuilder reusableBuffer = new StringBuilder();
    private boolean eof;
    private int index;
    private String string;
    private int bufferLength;
    private static final char[] TRUE = new char[]{'r', 'u', 'e'};
    private static final char[] FALSE = new char[]{'a', 'l', 's', 'e'};
    private static final char[] NULL = new char[]{'u', 'l', 'l'};

    JsonParser(String s) throws JsonParserException {
        this.string = s;
        this.bufferLength = s.length();
        this.eof = s.length() == 0;
    }

    public static JsonParserContext<JsonObject> object() {
        return new JsonParserContext<JsonObject>(JsonObject.class);
    }

    public static JsonParserContext<JsonArray> array() {
        return new JsonParserContext<JsonArray>(JsonArray.class);
    }

    public static JsonParserContext<Object> any() {
        return new JsonParserContext<Object>(Object.class);
    }

    <T> T parse(Class<T> clazz) throws JsonParserException {
        this.advanceToken();
        Object parsed = this.currentValue();
        if (this.advanceToken() != Token.EOF) {
            throw this.createParseException(null, "Expected end of input, got " + (Object)((Object)this.token), true);
        }
        if (clazz != Object.class && (parsed == null || clazz != parsed.getClass())) {
            throw this.createParseException(null, "JSON did not contain the correct type, expected " + clazz.getName() + ".", true);
        }
        return (T)parsed;
    }

    private Object currentValue() throws JsonParserException {
        if (this.token.isValue) {
            return this.value;
        }
        throw this.createParseException(null, "Expected JSON value, got " + (Object)((Object)this.token), true);
    }

    /*
     * Unable to fully structure code
     */
    private Token advanceToken() throws JsonParserException {
        c = this.advanceChar();
        while (this.isWhitespace(c)) {
            c = this.advanceChar();
        }
        this.tokenLinePos = this.linePos;
        this.tokenCharPos = this.index - this.rowPos - this.utf8adjust;
        this.tokenCharOffset = this.charOffset + this.index;
        switch (c) {
            case -1: {
                this.token = Token.EOF;
                return this.token;
            }
            case 91: {
                list = new JsonArray();
                if (this.advanceToken() == Token.ARRAY_END) ** GOTO lbl22
                do {
                    list.add(this.currentValue());
                    if (this.advanceToken() == Token.ARRAY_END) ** GOTO lbl22
                    if (this.token == Token.COMMA) continue;
                    throw this.createParseException(null, "Expected a comma or end of the array instead of " + (Object)this.token, true);
                } while (this.advanceToken() != Token.ARRAY_END);
                throw this.createParseException(null, "Trailing comma found in array", true);
lbl22:
                // 2 sources

                this.value = list;
                this.token = Token.ARRAY_START;
                return this.token;
            }
            case 93: {
                this.token = Token.ARRAY_END;
                return this.token;
            }
            case 44: {
                this.token = Token.COMMA;
                return this.token;
            }
            case 58: {
                this.token = Token.COLON;
                return this.token;
            }
            case 123: {
                map = new JsonObject();
                if (this.advanceToken() == Token.OBJECT_END) ** GOTO lbl51
                do {
                    if (this.token != Token.STRING) {
                        throw this.createParseException(null, "Expected STRING, got " + (Object)this.token, true);
                    }
                    key = (String)this.value;
                    if (this.advanceToken() != Token.COLON) {
                        throw this.createParseException(null, "Expected COLON, got " + (Object)this.token, true);
                    }
                    this.advanceToken();
                    map.put(key, this.currentValue());
                    if (this.advanceToken() == Token.OBJECT_END) ** GOTO lbl51
                    if (this.token == Token.COMMA) continue;
                    throw this.createParseException(null, "Expected a comma or end of the object instead of " + (Object)this.token, true);
                } while (this.advanceToken() != Token.OBJECT_END);
                throw this.createParseException(null, "Trailing object found in array", true);
lbl51:
                // 2 sources

                this.value = map;
                this.token = Token.OBJECT_START;
                return this.token;
            }
            case 125: {
                this.token = Token.OBJECT_END;
                return this.token;
            }
            case 116: {
                this.consumeKeyword((char)c, JsonParser.TRUE);
                this.value = Boolean.TRUE;
                this.token = Token.TRUE;
                return this.token;
            }
            case 102: {
                this.consumeKeyword((char)c, JsonParser.FALSE);
                this.value = Boolean.FALSE;
                this.token = Token.FALSE;
                return this.token;
            }
            case 110: {
                this.consumeKeyword((char)c, JsonParser.NULL);
                this.value = null;
                this.token = Token.NULL;
                return this.token;
            }
            case 34: {
                this.value = this.consumeTokenString();
                this.token = Token.STRING;
                return this.token;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.value = this.consumeTokenNumber((char)c);
                this.token = Token.NUMBER;
                return this.token;
            }
            case 43: 
            case 46: {
                throw this.createParseException(null, "Numbers may not start with '" + (char)c + "'", true);
            }
        }
        if (this.isAsciiLetter(c)) {
            throw this.createHelpfulException((char)c, null, 0);
        }
        throw this.createParseException(null, "Unexpected character: " + (char)c, true);
    }

    private void consumeKeyword(char first, char[] expected) throws JsonParserException {
        for (int i = 0; i < expected.length; ++i) {
            if (this.advanceChar() == expected[i]) continue;
            throw this.createHelpfulException(first, expected, i);
        }
        if (this.isAsciiLetter(this.peekChar())) {
            throw this.createHelpfulException(first, expected, expected.length);
        }
    }

    private Number consumeTokenNumber(char c) throws JsonParserException {
        int start = this.index - 1;
        int end = this.index;
        boolean isDouble = false;
        while (this.isDigitCharacter(this.peekChar())) {
            char next = (char)this.advanceChar();
            isDouble = next == '.' || next == 'e' || next == 'E' || isDouble;
            ++end;
        }
        String number = this.string.substring(start, end);
        try {
            int length;
            if (isDouble) {
                if (number.charAt(0) == '0' && (number.charAt(1) == '.' ? number.length() == 2 : number.charAt(1) != 'e' && number.charAt(1) != 'E')) {
                    throw this.createParseException(null, "Malformed number: " + number, true);
                }
                if (number.charAt(0) == '-' && (number.charAt(1) == '0' ? (number.charAt(2) == '.' ? number.length() == 3 : number.charAt(2) != 'e' && number.charAt(2) != 'E') : number.charAt(1) == '.')) {
                    throw this.createParseException(null, "Malformed number: " + number, true);
                }
                return Double.parseDouble(number);
            }
            if (number.charAt(0) == '0') {
                if (number.length() == 1) {
                    return 0;
                }
                throw this.createParseException(null, "Malformed number: " + number, true);
            }
            if (number.length() > 1 && number.charAt(0) == '-' && number.charAt(1) == '0') {
                if (number.length() == 2) {
                    return -0.0;
                }
                throw this.createParseException(null, "Malformed number: " + number, true);
            }
            int n = length = number.charAt(0) == '-' ? number.length() - 1 : number.length();
            if (length < 10) {
                return Integer.parseInt(number);
            }
            if (length < 19) {
                return Long.parseLong(number);
            }
            return new BigInteger(number);
        }
        catch (NumberFormatException e) {
            throw this.createParseException(e, "Malformed number: " + number, true);
        }
    }

    private String consumeTokenString() throws JsonParserException {
        this.reusableBuffer.setLength(0);
        block14: while (true) {
            char c = this.stringChar();
            switch (c) {
                case '\"': {
                    return this.reusableBuffer.toString();
                }
                case '\\': {
                    int escape = this.advanceChar();
                    switch (escape) {
                        case -1: {
                            throw this.createParseException(null, "EOF encountered in the middle of a string escape", false);
                        }
                        case 98: {
                            this.reusableBuffer.append('\b');
                            continue block14;
                        }
                        case 102: {
                            this.reusableBuffer.append('\f');
                            continue block14;
                        }
                        case 110: {
                            this.reusableBuffer.append('\n');
                            continue block14;
                        }
                        case 114: {
                            this.reusableBuffer.append('\r');
                            continue block14;
                        }
                        case 116: {
                            this.reusableBuffer.append('\t');
                            continue block14;
                        }
                        case 34: 
                        case 47: 
                        case 92: {
                            this.reusableBuffer.append((char)escape);
                            continue block14;
                        }
                        case 117: {
                            this.reusableBuffer.append((char)(this.stringHexChar() << 12 | this.stringHexChar() << 8 | this.stringHexChar() << 4 | this.stringHexChar()));
                            continue block14;
                        }
                    }
                    throw this.createParseException(null, "Invalid escape: \\" + (char)escape, false);
                }
            }
            this.reusableBuffer.append(c);
        }
    }

    private char stringChar() throws JsonParserException {
        int c = this.advanceChar();
        if (c == -1) {
            throw this.createParseException(null, "String was not terminated before end of input", true);
        }
        if (c < 32) {
            throw this.createParseException(null, "Strings may not contain control characters: 0x" + Integer.toString(c, 16), false);
        }
        return (char)c;
    }

    private int stringHexChar() throws JsonParserException {
        int c = "0123456789abcdef0123456789ABCDEF".indexOf(this.advanceChar()) % 16;
        if (c == -1) {
            throw this.createParseException(null, "Expected unicode hex escape character", false);
        }
        return c;
    }

    private boolean isDigitCharacter(int c) {
        return c >= 48 && c <= 57 || c == 101 || c == 69 || c == 46 || c == 43 || c == 45;
    }

    private boolean isWhitespace(int c) {
        return c == 32 || c == 10 || c == 13 || c == 9;
    }

    private boolean isAsciiLetter(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122;
    }

    private int peekChar() {
        return this.eof ? -1 : (int)this.string.charAt(this.index);
    }

    private int advanceChar() throws JsonParserException {
        if (this.eof) {
            return -1;
        }
        char c = this.string.charAt(this.index);
        if (c == '\n') {
            ++this.linePos;
            this.rowPos = this.index + 1;
            this.utf8adjust = 0;
        }
        ++this.index;
        if (this.index >= this.bufferLength) {
            this.eof = true;
        }
        return c;
    }

    private JsonParserException createHelpfulException(char first, char[] expected, int failurePosition) throws JsonParserException {
        StringBuilder errorToken = new StringBuilder(first + (expected == null ? "" : new String(expected, 0, failurePosition)));
        while (this.isAsciiLetter(this.peekChar()) && errorToken.length() < 15) {
            errorToken.append((char)this.advanceChar());
        }
        return this.createParseException(null, "Unexpected token '" + errorToken + "'" + (expected == null ? "" : ". Did you mean '" + first + new String(expected) + "'?"), true);
    }

    private JsonParserException createParseException(Exception e, String message, boolean tokenPos) {
        if (tokenPos) {
            return new JsonParserException(e, message + " on line " + this.tokenLinePos + ", char " + this.tokenCharPos, this.tokenLinePos, this.tokenCharPos, this.tokenCharOffset);
        }
        int charPos = Math.max(1, this.index - this.rowPos - this.utf8adjust);
        return new JsonParserException(e, message + " on line " + this.linePos + ", char " + charPos, this.linePos, charPos, this.index + this.charOffset);
    }

    public static final class JsonParserContext<T> {
        private final Class<T> clazz;

        JsonParserContext(Class<T> clazz) {
            this.clazz = clazz;
        }

        public T from(String s) throws JsonParserException {
            return new JsonParser(s).parse(this.clazz);
        }
    }

    private static enum Token {
        EOF(false),
        NULL(true),
        TRUE(true),
        FALSE(true),
        STRING(true),
        NUMBER(true),
        COMMA(false),
        COLON(false),
        OBJECT_START(true),
        OBJECT_END(false),
        ARRAY_START(true),
        ARRAY_END(false);

        public boolean isValue;

        private Token(boolean isValue) {
            this.isValue = isValue;
        }
    }
}

