/*
 * Decompiled with CFR 0.152.
 */
package playn.core.json;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import playn.core.Json;
import playn.core.json.JsonBuilder;
import playn.core.json.JsonImpl;
import playn.core.json.JsonSink;
import playn.core.json.JsonStringTypedArray;
import playn.core.json.JsonTypedArray;

class JsonObject
implements Json.Object {
    private final Map<String, Object> map = new TreeMap<String, Object>();

    public static JsonBuilder<JsonObject> builder() {
        return new JsonBuilder<JsonObject>(new JsonObject());
    }

    @Override
    public Json.Array getArray(String key) {
        return this.getArray(key, (Json.Array)null);
    }

    @Override
    public Json.Array getArray(String key, Json.Array default_) {
        Object o = this.get(key);
        return o instanceof Json.Array ? (Json.Array)o : default_;
    }

    @Override
    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    @Override
    public boolean getBoolean(String key, boolean default_) {
        Object o = this.get(key);
        return o instanceof Boolean ? (Boolean)o : default_;
    }

    @Override
    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    @Override
    public double getDouble(String key, double default_) {
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).doubleValue() : default_;
    }

    @Override
    public float getNumber(String key) {
        return this.getNumber(key, 0.0f);
    }

    @Override
    public float getNumber(String key, float default_) {
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).floatValue() : default_;
    }

    @Override
    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    @Override
    public int getInt(String key, int default_) {
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).intValue() : default_;
    }

    @Override
    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    @Override
    public long getLong(String key, long default_) {
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).longValue() : default_;
    }

    @Override
    public Json.Object getObject(String key) {
        return this.getObject(key, null);
    }

    @Override
    public Json.Object getObject(String key, Json.Object default_) {
        Object o = this.get(key);
        return o instanceof JsonObject ? (JsonObject)o : default_;
    }

    @Override
    public String getString(String key) {
        return this.getString(key, null);
    }

    @Override
    public String getString(String key, String default_) {
        Object o = this.get(key);
        return o instanceof String ? (String)o : default_;
    }

    @Override
    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean isArray(String key) {
        return this.get(key) instanceof Json.Array;
    }

    @Override
    public boolean isBoolean(String key) {
        return this.get(key) instanceof Boolean;
    }

    @Override
    public boolean isNull(String key) {
        return this.get(key) == null;
    }

    @Override
    public boolean isNumber(String key) {
        return this.get(key) instanceof Number;
    }

    @Override
    public boolean isString(String key) {
        return this.get(key) instanceof String;
    }

    @Override
    public boolean isObject(String key) {
        return this.get(key) instanceof Json.Object;
    }

    @Override
    public <T> Json.TypedArray<T> getArray(String key, Class<T> valueType) {
        return this.getArray(key, valueType, null);
    }

    @Override
    public <T> Json.TypedArray<T> getArray(String key, Class<T> valueType, Json.TypedArray<T> dflt) {
        Json.Array array = this.getArray(key);
        return array == null ? dflt : new JsonTypedArray<T>(array, valueType);
    }

    @Override
    public Json.TypedArray<String> keys() {
        return new JsonStringTypedArray((Collection<String>)this.map.keySet());
    }

    @Override
    public void put(String key, Object value) {
        JsonImpl.checkJsonType(value);
        this.map.put(key, value);
    }

    @Override
    public void remove(String key) {
        this.map.remove(key);
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public <T extends JsonSink<T>> JsonSink<T> write(JsonSink<T> sink) {
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            sink.value(entry.getKey(), entry.getValue());
        }
        return sink;
    }

    Object get(String key) {
        return this.map.get(key);
    }
}

