/*
 * Decompiled with CFR 0.152.
 */
package playn.core.json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import playn.core.Json;
import playn.core.json.JsonBuilder;
import playn.core.json.JsonImpl;
import playn.core.json.JsonSink;
import playn.core.json.JsonTypedArray;

class JsonArray
implements Json.Array {
    private final ArrayList<Object> list;

    public JsonArray() {
        this.list = new ArrayList();
    }

    JsonArray(Collection<? extends Object> collection) {
        this.list = new ArrayList<Object>(collection);
    }

    static JsonArray from(Object ... contents) {
        return new JsonArray(Arrays.asList(contents));
    }

    public static JsonBuilder<JsonArray> builder() {
        return new JsonBuilder<JsonArray>(new JsonArray());
    }

    @Override
    public void add(Object value) {
        JsonImpl.checkJsonType(value);
        this.list.add(value);
    }

    @Override
    public void add(int index, Object value) {
        JsonImpl.checkJsonType(value);
        while (this.list.size() < index) {
            this.list.add(null);
        }
        this.list.add(index, value);
    }

    @Override
    public Json.Array getArray(int key) {
        return this.getArray(key, (Json.Array)null);
    }

    @Override
    public Json.Array getArray(int key, Json.Array default_) {
        Object o = this.get(key);
        return o instanceof Json.Array ? (Json.Array)this.get(key) : default_;
    }

    @Override
    public <T> Json.TypedArray<T> getArray(int index, Class<T> jsonType) {
        Json.Array array = this.getArray(index);
        return array == null ? null : new JsonTypedArray<T>(array, jsonType);
    }

    @Override
    public boolean getBoolean(int key) {
        return this.getBoolean(key, false);
    }

    @Override
    public boolean getBoolean(int key, boolean default_) {
        Object o = this.get(key);
        return o instanceof Boolean ? (Boolean)o : default_;
    }

    @Override
    public double getDouble(int key) {
        return this.getDouble(key, 0.0);
    }

    @Override
    public double getDouble(int key, double default_) {
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).doubleValue() : default_;
    }

    @Override
    public float getNumber(int key) {
        return this.getNumber(key, 0.0f);
    }

    @Override
    public float getNumber(int key, float default_) {
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).floatValue() : default_;
    }

    @Override
    public int getInt(int key) {
        return this.getInt(key, 0);
    }

    @Override
    public int getInt(int key, int default_) {
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).intValue() : default_;
    }

    @Override
    public long getLong(int key) {
        return this.getLong(key, 0L);
    }

    @Override
    public long getLong(int key, long default_) {
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).longValue() : default_;
    }

    @Override
    public Json.Object getObject(int key) {
        return this.getObject(key, null);
    }

    @Override
    public Json.Object getObject(int key, Json.Object default_) {
        Object o = this.get(key);
        return o instanceof Json.Object ? (Json.Object)this.get(key) : default_;
    }

    @Override
    public String getString(int key) {
        return this.getString(key, null);
    }

    @Override
    public String getString(int key, String default_) {
        Object o = this.get(key);
        return o instanceof String ? (String)o : default_;
    }

    @Override
    public boolean isArray(int key) {
        return this.get(key) instanceof Json.Array;
    }

    @Override
    public boolean isBoolean(int key) {
        return this.get(key) instanceof Boolean;
    }

    @Override
    public boolean isNull(int key) {
        return this.get(key) == null;
    }

    @Override
    public boolean isNumber(int key) {
        return this.get(key) instanceof Number;
    }

    @Override
    public boolean isString(int key) {
        return this.get(key) instanceof String;
    }

    @Override
    public boolean isObject(int key) {
        return this.get(key) instanceof Json.Object;
    }

    @Override
    public int length() {
        return this.list.size();
    }

    @Override
    public void remove(int index) {
        if (index < 0 || index >= this.list.size()) {
            return;
        }
        this.list.remove(index);
    }

    @Override
    public void set(int index, Object value) {
        JsonImpl.checkJsonType(value);
        while (this.list.size() <= index) {
            this.list.add(null);
        }
        this.list.set(index, value);
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public <T extends JsonSink<T>> JsonSink<T> write(JsonSink<T> sink) {
        for (int i = 0; i < this.list.size(); ++i) {
            sink.value(this.list.get(i));
        }
        return sink;
    }

    Object get(int key) {
        return key >= 0 && key < this.list.size() ? this.list.get(key) : null;
    }
}

