/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import java.util.HashMap;
import java.util.Map;
import playn.core.Assets;
import playn.core.Audio;
import playn.core.BatchImpl;
import playn.core.Exec;
import playn.core.Graphics;
import playn.core.Input;
import playn.core.Json;
import playn.core.Log;
import playn.core.Net;
import playn.core.Platform;
import playn.core.Storage;
import playn.core.json.JsonImpl;

public class StubPlatform
extends Platform {
    private Storage storage = new Storage(){
        private final Map<String, String> _data = new HashMap<String, String>();

        @Override
        public void setItem(String key, String data) throws RuntimeException {
            this._data.put(key, data);
        }

        @Override
        public void removeItem(String key) {
            this._data.remove(key);
        }

        @Override
        public String getItem(String key) {
            return this._data.get(key);
        }

        @Override
        public Storage.Batch startBatch() {
            return new BatchImpl(this);
        }

        @Override
        public Iterable<String> keys() {
            return this._data.keySet();
        }

        @Override
        public boolean isPersisted() {
            return true;
        }
    };
    private Input input = new Input();
    private Json json = new JsonImpl();
    private Log log = new Log(){

        @Override
        protected void logImpl(Log.Level level, String msg, Throwable e) {
            String prefix;
            switch (level) {
                default: {
                    prefix = "D: ";
                    break;
                }
                case INFO: {
                    prefix = "";
                    break;
                }
                case WARN: {
                    prefix = "W: ";
                    break;
                }
                case ERROR: {
                    prefix = "E: ";
                }
            }
            System.err.println(prefix + msg);
            if (e != null) {
                e.printStackTrace(System.err);
            }
        }
    };
    private Exec exec = new Exec.Default(this.log, this.frame){

        @Override
        public void invokeLater(Runnable action) {
            action.run();
        }
    };
    private final long start = System.currentTimeMillis();

    @Override
    public Platform.Type type() {
        return Platform.Type.STUB;
    }

    @Override
    public double time() {
        return System.currentTimeMillis();
    }

    @Override
    public int tick() {
        return (int)(System.currentTimeMillis() - this.start);
    }

    @Override
    public void openURL(String url) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Assets assets() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Audio audio() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Graphics graphics() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Net net() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Exec exec() {
        return this.exec;
    }

    @Override
    public Input input() {
        return this.input;
    }

    @Override
    public Json json() {
        return this.json;
    }

    @Override
    public Log log() {
        return this.log;
    }

    @Override
    public Storage storage() {
        return this.storage;
    }
}

