/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.Exec;
import playn.core.Sound;
import pythagoras.f.MathUtil;
import react.RFuture;
import react.RPromise;

public abstract class SoundImpl<I>
extends Sound {
    protected boolean playing;
    protected boolean looping;
    protected float volume = 1.0f;
    protected I impl;

    public SoundImpl(Exec exec) {
        super((RFuture<Sound>)exec.deferredPromise());
    }

    public synchronized void succeed(I impl) {
        this.impl = impl;
        this.setVolumeImpl(this.volume);
        this.setLoopingImpl(this.looping);
        if (this.playing) {
            this.playImpl();
        }
        ((RPromise)this.state).succeed((Object)this);
    }

    public synchronized void fail(Throwable error) {
        ((RPromise)this.state).fail(error);
    }

    @Override
    public boolean prepare() {
        return this.impl != null ? this.prepareImpl() : false;
    }

    @Override
    public boolean isPlaying() {
        return this.impl != null ? this.playingImpl() : this.playing;
    }

    @Override
    public boolean play() {
        this.playing = true;
        return this.impl == null ? false : this.playImpl();
    }

    @Override
    public void stop() {
        this.playing = false;
        if (this.impl != null) {
            this.stopImpl();
        }
    }

    @Override
    public void setLooping(boolean looping) {
        this.looping = looping;
        if (this.impl != null) {
            this.setLoopingImpl(looping);
        }
    }

    @Override
    public float volume() {
        return this.volume;
    }

    @Override
    public void setVolume(float volume) {
        this.volume = MathUtil.clamp((float)volume, (float)0.0f, (float)1.0f);
        if (this.impl != null) {
            this.setVolumeImpl(this.volume);
        }
    }

    @Override
    public void release() {
        if (this.impl != null) {
            this.releaseImpl();
            this.impl = null;
        }
    }

    protected void finalize() {
        this.release();
    }

    protected boolean prepareImpl() {
        return false;
    }

    protected boolean playingImpl() {
        return this.playing;
    }

    protected abstract boolean playImpl();

    protected abstract void stopImpl();

    protected abstract void setLoopingImpl(boolean var1);

    protected abstract void setVolumeImpl(float var1);

    protected abstract void releaseImpl();
}

