/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.Disposable;
import playn.core.GL20;
import playn.core.Graphics;
import playn.core.Texture;

public abstract class RenderTarget
implements Disposable {
    public final Graphics gfx;
    private boolean disposed;

    public static RenderTarget create(Graphics gfx, final Texture tex) {
        GL20 gl = gfx.gl;
        final int fb = gl.glGenFramebuffer();
        if (fb == 0) {
            throw new RuntimeException("Failed to gen framebuffer: " + gl.glGetError());
        }
        gl.glBindFramebuffer(36160, fb);
        gl.glFramebufferTexture2D(36160, 36064, 3553, tex.id, 0);
        gl.checkError("RenderTarget.create");
        return new RenderTarget(gfx){

            @Override
            public int id() {
                return fb;
            }

            @Override
            public int width() {
                return tex.pixelWidth;
            }

            @Override
            public int height() {
                return tex.pixelHeight;
            }

            @Override
            public float xscale() {
                return (float)tex.pixelWidth / tex.displayWidth;
            }

            @Override
            public float yscale() {
                return (float)tex.pixelHeight / tex.displayHeight;
            }

            @Override
            public boolean flip() {
                return false;
            }
        };
    }

    public RenderTarget(Graphics gfx) {
        this.gfx = gfx;
    }

    public abstract int id();

    public abstract int width();

    public abstract int height();

    public abstract float xscale();

    public abstract float yscale();

    public abstract boolean flip();

    public void bind() {
        this.gfx.gl.glBindFramebuffer(36160, this.id());
        this.gfx.gl.glViewport(0, 0, this.width(), this.height());
    }

    @Override
    public void close() {
        if (!this.disposed) {
            this.disposed = true;
            this.gfx.gl.glDeleteFramebuffer(this.id());
        }
    }

    public String toString() {
        return "[id=" + this.id() + ", size=" + this.width() + "x" + this.height() + " @ " + this.xscale() + "x" + this.yscale() + ", flip=" + this.flip() + "]";
    }

    protected void finalize() {
        if (!this.disposed) {
            this.gfx.queueForDispose(this);
        }
    }
}

