/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.Event;
import playn.core.Mouse;
import playn.core.Platform;
import playn.core.Touch;
import react.Signal;
import react.Slot;

public class Pointer {
    public boolean enabled = true;
    public Signal<Event> events = Signal.create();

    public Pointer(Platform plat) {
        plat.input().mouseEvents.connect((Slot)new Slot<Mouse.Event>(){
            private boolean dragging;

            public void onEmit(Mouse.Event event) {
                if (event instanceof Mouse.MotionEvent) {
                    if (this.dragging) {
                        Pointer.this.forward(Event.Kind.DRAG, false, event);
                    }
                } else if (event instanceof Mouse.ButtonEvent) {
                    Mouse.ButtonEvent bevent = (Mouse.ButtonEvent)event;
                    if (bevent.button == Mouse.ButtonEvent.Id.LEFT) {
                        this.dragging = bevent.down;
                        Pointer.this.forward(bevent.down ? Event.Kind.START : Event.Kind.END, false, bevent);
                    }
                }
            }
        });
        plat.input().touchEvents.connect((Slot)new Slot<Touch.Event[]>(){
            private int active = -1;

            public void onEmit(Touch.Event[] events) {
                for (Touch.Event event : events) {
                    if (this.active == -1 && event.kind.isStart) {
                        this.active = event.id;
                    }
                    if (event.id != this.active) continue;
                    Pointer.this.forward(Event.Kind.values()[event.kind.ordinal()], true, event);
                    if (!event.kind.isEnd) continue;
                    this.active = -1;
                }
            }
        });
    }

    protected void forward(Event.Kind kind, boolean isTouch, Event.XY source) {
        if (!this.enabled || !this.events.hasConnections()) {
            return;
        }
        this.events.emit((Object)new Event(source.flags, source.time, source.x, source.y, kind, isTouch));
    }

    public static class Event
    extends Event.XY {
        public final Kind kind;
        public boolean isTouch;

        public Event(int flags, double time, float x, float y, Kind kind, boolean isTouch) {
            super(flags, time, x, y);
            this.kind = kind;
            this.isTouch = isTouch;
        }

        @Override
        protected String name() {
            return "Pointer";
        }

        @Override
        protected void addFields(StringBuilder builder) {
            super.addFields(builder);
            builder.append(", kind=").append((Object)this.kind);
            builder.append(", touch=").append(this.isTouch);
        }

        public static enum Kind {
            START(true, false),
            DRAG(false, false),
            END(false, true),
            CANCEL(false, true);

            public final boolean isStart;
            public final boolean isEnd;

            private Kind(boolean isStart, boolean isEnd) {
                this.isStart = isStart;
                this.isEnd = isEnd;
            }
        }
    }
}

