/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.Assets;
import playn.core.Audio;
import playn.core.Exec;
import playn.core.Graphics;
import playn.core.Input;
import playn.core.Json;
import playn.core.Log;
import playn.core.Net;
import playn.core.Storage;
import react.Signal;

public abstract class Platform {
    public Signal<Lifecycle> lifecycle = Signal.create();
    public Signal<Platform> frame = Signal.create();
    public Signal<Error> errors = Signal.create();

    public abstract Type type();

    public abstract double time();

    public abstract int tick();

    public abstract void openURL(String var1);

    public abstract Assets assets();

    public abstract Audio audio();

    public abstract Exec exec();

    public abstract Graphics graphics();

    public abstract Input input();

    public abstract Json json();

    public abstract Log log();

    public abstract Net net();

    public abstract Storage storage();

    public void reportError(String message, Throwable cause) {
        this.errors.emit((Object)new Error(message, cause));
        this.log().warn(message, cause);
    }

    @Deprecated
    public void invokeLater(Runnable runnable) {
        this.exec().invokeLater(runnable);
    }

    @Deprecated
    public boolean isAsyncSupported() {
        return this.exec().isAsyncSupported();
    }

    @Deprecated
    public void invokeAsync(Runnable action) {
        this.exec().invokeAsync(action);
    }

    protected void emitFrame() {
        try {
            this.frame.emit((Object)this);
        }
        catch (Exception e) {
            this.log().warn("Frame tick exception", e);
        }
    }

    public static enum Type {
        JAVA,
        HTML,
        ANDROID,
        IOS,
        STUB;

    }

    public static class Error {
        public final String message;
        public final Throwable cause;

        public Error(String message, Throwable cause) {
            this.message = message;
            this.cause = cause;
        }
    }

    public static enum Lifecycle {
        PAUSE,
        RESUME,
        EXIT;

    }
}

