/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import playn.core.json.JsonParserException;
import playn.core.json.JsonSink;

public interface Json {
    public Array createArray();

    public Object createObject();

    public boolean isArray(java.lang.Object var1);

    public boolean isObject(java.lang.Object var1);

    public Writer newWriter();

    public Object parse(String var1) throws JsonParserException;

    public Array parseArray(String var1) throws JsonParserException;

    public static interface Object {
        public boolean getBoolean(String var1);

        public boolean getBoolean(String var1, boolean var2);

        public float getNumber(String var1);

        public float getNumber(String var1, float var2);

        public double getDouble(String var1);

        public double getDouble(String var1, double var2);

        public int getInt(String var1);

        public int getInt(String var1, int var2);

        public long getLong(String var1);

        public long getLong(String var1, long var2);

        public String getString(String var1);

        public String getString(String var1, String var2);

        public Object getObject(String var1);

        public Object getObject(String var1, Object var2);

        public Array getArray(String var1);

        public Array getArray(String var1, Array var2);

        public <T> TypedArray<T> getArray(String var1, Class<T> var2);

        public <T> TypedArray<T> getArray(String var1, Class<T> var2, TypedArray<T> var3);

        public boolean containsKey(String var1);

        public TypedArray<String> keys();

        public boolean isArray(String var1);

        public boolean isBoolean(String var1);

        public boolean isNull(String var1);

        public boolean isNumber(String var1);

        public boolean isString(String var1);

        public boolean isObject(String var1);

        public void put(String var1, java.lang.Object var2);

        public void remove(String var1);

        public <T extends JsonSink<T>> JsonSink<T> write(JsonSink<T> var1);
    }

    public static interface Array {
        public int length();

        public boolean getBoolean(int var1);

        public boolean getBoolean(int var1, boolean var2);

        public float getNumber(int var1);

        public float getNumber(int var1, float var2);

        public double getDouble(int var1);

        public double getDouble(int var1, double var2);

        public int getInt(int var1);

        public int getInt(int var1, int var2);

        public long getLong(int var1);

        public long getLong(int var1, long var2);

        public String getString(int var1);

        public String getString(int var1, String var2);

        public Object getObject(int var1);

        public Object getObject(int var1, Object var2);

        public Array getArray(int var1);

        public Array getArray(int var1, Array var2);

        public <T> TypedArray<T> getArray(int var1, Class<T> var2);

        public boolean isArray(int var1);

        public boolean isBoolean(int var1);

        public boolean isNull(int var1);

        public boolean isNumber(int var1);

        public boolean isString(int var1);

        public boolean isObject(int var1);

        public void add(java.lang.Object var1);

        public void add(int var1, java.lang.Object var2);

        public void remove(int var1);

        public void set(int var1, java.lang.Object var2);

        public <T extends JsonSink<T>> JsonSink<T> write(JsonSink<T> var1);
    }

    public static interface TypedArray<T>
    extends Iterable<T> {
        public int length();

        public T get(int var1);

        public T get(int var1, T var2);

        @Override
        public Iterator<T> iterator();

        public static class Util {
            public static TypedArray<Boolean> create(Boolean ... data) {
                return Util.toArray(data);
            }

            public static TypedArray<Integer> create(Integer ... data) {
                return Util.toArray(data);
            }

            public static TypedArray<Float> create(Float ... data) {
                return Util.toArray(data);
            }

            public static TypedArray<Double> create(Double ... data) {
                return Util.toArray(data);
            }

            public static TypedArray<String> create(String ... data) {
                return Util.toArray(data);
            }

            public static TypedArray<Object> create(Object ... data) {
                return Util.toArray(data);
            }

            public static TypedArray<Array> create(Array ... data) {
                return Util.toArray(data);
            }

            private static <T> TypedArray<T> toArray(final java.lang.Object[] data) {
                return new TypedArray<T>(){

                    @Override
                    public int length() {
                        return data.length;
                    }

                    @Override
                    public T get(int index) {
                        java.lang.Object value = data[index];
                        return value;
                    }

                    @Override
                    public T get(int index, T dflt) {
                        return index < 0 || index >= data.length ? dflt : this.get(index);
                    }

                    @Override
                    public Iterator<T> iterator() {
                        List<java.lang.Object> list = Arrays.asList(data);
                        return list.iterator();
                    }
                };
            }
        }
    }

    public static interface Writer
    extends JsonSink<Writer> {
        public String write();

        public Writer useVerboseFormat(boolean var1);
    }
}

