/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.Key;
import playn.core.Keyboard;
import playn.core.Mouse;
import playn.core.Touch;
import react.RFuture;
import react.Signal;

public class Input {
    public boolean mouseEnabled = true;
    public boolean touchEnabled = true;
    public boolean keyboardEnabled = true;
    public Signal<Mouse.Event> mouseEvents = Signal.create();
    public Signal<Touch.Event[]> touchEvents = Signal.create();
    public Signal<Keyboard.Event> keyboardEvents = Signal.create();

    public boolean hasMouse() {
        return false;
    }

    public boolean hasTouch() {
        return false;
    }

    public boolean hasHardwareKeyboard() {
        return false;
    }

    public boolean hasMouseLock() {
        return false;
    }

    public boolean isMouseLocked() {
        return false;
    }

    public void setMouseLocked(boolean locked) {
    }

    public RFuture<String> getText(Keyboard.TextType textType, String label, String initialValue) {
        return RFuture.failure((Throwable)new Exception("getText not supported"));
    }

    protected void emitKeyPress(double time, Key key, boolean down) {
        this.keyboardEvents.emit((Object)new Keyboard.KeyEvent(0, time, key, down));
    }

    protected void emitKeyTyped(double time, char keyChar) {
        this.keyboardEvents.emit((Object)new Keyboard.TypedEvent(0, time, keyChar));
    }

    protected void emitMouseButton(double time, float x, float y, Mouse.ButtonEvent.Id btn, boolean down) {
        this.mouseEvents.emit((Object)new Mouse.ButtonEvent(0, time, x, y, btn, down));
    }

    protected void emitMouseMotion(double time, float x, float y, float dx, float dy) {
        this.mouseEvents.emit((Object)new Mouse.MotionEvent(0, time, x, y, dx, dy));
    }

    protected void emitMouseWheel(double time, float x, float y, int delta) {
        this.mouseEvents.emit((Object)new Mouse.WheelEvent(0, time, x, y, delta));
    }
}

