/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.Graphics;
import playn.core.Image;
import playn.core.Platform;
import playn.core.Scale;
import react.RFuture;
import react.RPromise;

public abstract class ImageImpl
extends Image {
    protected Scale scale;
    protected int pixelWidth;
    protected int pixelHeight;

    public synchronized void succeed(Data data) {
        this.scale = data.scale;
        this.pixelWidth = data.pixelWidth;
        assert (this.pixelWidth > 0);
        this.pixelHeight = data.pixelHeight;
        assert (this.pixelHeight > 0);
        this.setBitmap(data.bitmap);
        ((RPromise)this.state).succeed((Object)this);
    }

    public synchronized void fail(Throwable error) {
        if (this.pixelWidth == 0) {
            this.pixelWidth = 50;
        }
        if (this.pixelHeight == 0) {
            this.pixelHeight = 50;
        }
        this.setBitmap(this.createErrorBitmap(this.pixelWidth, this.pixelHeight));
        ((RPromise)this.state).fail(error);
    }

    @Override
    public Scale scale() {
        return this.scale;
    }

    @Override
    public int pixelWidth() {
        return this.pixelWidth;
    }

    @Override
    public int pixelHeight() {
        return this.pixelHeight;
    }

    protected ImageImpl(Graphics gfx, Scale scale, int pixelWidth, int pixelHeight, Object bitmap) {
        super(gfx);
        if (pixelWidth == 0 || pixelHeight == 0) {
            throw new IllegalArgumentException("Invalid size for ready image: " + pixelWidth + "x" + pixelHeight + " bitmap: " + bitmap);
        }
        this.scale = scale;
        this.pixelWidth = pixelWidth;
        this.pixelHeight = pixelHeight;
        this.setBitmap(bitmap);
    }

    protected ImageImpl(Graphics gfx, RFuture<Image> state, Scale preScale, int preWidth, int preHeight) {
        super(gfx, state);
        this.scale = preScale;
        this.pixelWidth = preWidth;
        this.pixelHeight = preHeight;
    }

    protected ImageImpl(Platform plat, boolean async, Scale preScale, int preWidth, int preHeight) {
        this(plat.graphics(), (RFuture<Image>)(async ? plat.exec().deferredPromise() : RPromise.create()), preScale, preWidth, preHeight);
    }

    protected abstract void setBitmap(Object var1);

    protected abstract Object createErrorBitmap(int var1, int var2);

    public static class Data {
        public final Scale scale;
        public final Object bitmap;
        public final int pixelWidth;
        public final int pixelHeight;

        public Data(Scale scale, Object bitmap, int pixelWidth, int pixelHeight) {
            this.bitmap = bitmap;
            this.scale = scale;
            this.pixelWidth = pixelWidth;
            this.pixelHeight = pixelHeight;
        }
    }
}

