/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.Canvas;
import playn.core.Disposable;
import playn.core.GL20;
import playn.core.Platform;
import playn.core.RenderTarget;
import playn.core.Scale;
import playn.core.TextFormat;
import playn.core.TextLayout;
import playn.core.TextWrap;
import playn.core.Texture;
import pythagoras.f.Dimension;
import pythagoras.f.IDimension;
import react.Slot;
import react.UnitSlot;

public abstract class Graphics {
    protected final Platform plat;
    protected final Dimension viewSizeM = new Dimension();
    protected Scale scale;
    protected int viewPixelWidth;
    protected int viewPixelHeight;
    private Texture colorTex;
    public final GL20 gl;
    public final IDimension viewSize = this.viewSizeM;
    public RenderTarget defaultRenderTarget = new RenderTarget(this){

        @Override
        public int id() {
            return Graphics.this.defaultFramebuffer();
        }

        @Override
        public int width() {
            return Graphics.this.viewPixelWidth;
        }

        @Override
        public int height() {
            return Graphics.this.viewPixelHeight;
        }

        @Override
        public float xscale() {
            return Graphics.this.scale.factor;
        }

        @Override
        public float yscale() {
            return Graphics.this.scale.factor;
        }

        @Override
        public boolean flip() {
            return true;
        }

        @Override
        public void close() {
        }
    };

    public Scale scale() {
        return this.scale;
    }

    public abstract IDimension screenSize();

    public Canvas createCanvas(float width, float height) {
        return this.createCanvasImpl(this.scale, this.scale.scaledCeil(width), this.scale.scaledCeil(height));
    }

    public Canvas createCanvas(IDimension size) {
        return this.createCanvas(size.width(), size.height());
    }

    public Texture createTexture(float width, float height, Texture.Config config) {
        int texWidth = config.toTexWidth(this.scale.scaledCeil(width));
        int texHeight = config.toTexHeight(this.scale.scaledCeil(height));
        if (texWidth <= 0 || texHeight <= 0) {
            throw new IllegalArgumentException("Invalid texture size: " + texWidth + "x" + texHeight);
        }
        int id = this.createTexture(config);
        this.gl.glTexImage2D(3553, 0, 6408, texWidth, texHeight, 0, 6408, 5121, null);
        return new Texture(this, id, config, texWidth, texHeight, this.scale, width, height);
    }

    public Texture createTexture(IDimension size, Texture.Config config) {
        return this.createTexture(size.width(), size.height(), config);
    }

    public abstract TextLayout layoutText(String var1, TextFormat var2);

    public abstract TextLayout[] layoutText(String var1, TextFormat var2, TextWrap var3);

    public void queueForDispose(final Disposable resource) {
        this.plat.frame.connect((Slot)new UnitSlot(){

            public void onEmit() {
                resource.close();
            }
        }).once();
    }

    Texture colorTex() {
        if (this.colorTex == null) {
            Canvas canvas = this.createCanvas(1.0f, 1.0f);
            canvas.setFillColor(-1).fillRect(0.0f, 0.0f, canvas.width, canvas.height);
            this.colorTex = canvas.toTexture(Texture.Config.UNMANAGED);
        }
        return this.colorTex;
    }

    protected Graphics(Platform plat, GL20 gl, Scale scale) {
        this.plat = plat;
        this.gl = gl;
        this.scale = scale;
    }

    protected int defaultFramebuffer() {
        return 0;
    }

    protected abstract Canvas createCanvasImpl(Scale var1, int var2, int var3);

    protected void viewportChanged(Scale scale, int viewWidth, int viewHeight) {
        this.scale = scale;
        this.viewPixelWidth = viewWidth;
        this.viewPixelHeight = viewHeight;
        this.viewSizeM.width = scale.invScaled(viewWidth);
        this.viewSizeM.height = scale.invScaled(viewHeight);
    }

    int createTexture(Texture.Config config) {
        int id = this.gl.glGenTexture();
        this.gl.glBindTexture(3553, id);
        this.gl.glTexParameteri(3553, 10240, config.magFilter);
        int minFilter = Graphics.mipmapify(config.minFilter, config.mipmaps);
        this.gl.glTexParameteri(3553, 10241, minFilter);
        this.gl.glTexParameteri(3553, 10242, config.repeatX ? 10497 : 33071);
        this.gl.glTexParameteri(3553, 10243, config.repeatY ? 10497 : 33071);
        return id;
    }

    protected static int mipmapify(int filter, boolean mipmaps) {
        if (!mipmaps) {
            return filter;
        }
        switch (filter) {
            case 9728: {
                return 9984;
            }
            case 9729: {
                return 9985;
            }
        }
        return filter;
    }
}

