/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.Clock;
import playn.core.Platform;
import react.Signal;
import react.Slot;

public abstract class Game {
    public final Platform plat;
    public final Signal<Clock> update = Signal.create();
    public final Signal<Clock> paint = Signal.create();
    private final Clock updateClock = new Clock();
    private final Clock paintClock = new Clock();
    private final int updateRate;
    private int nextUpdate;

    public Game(Platform plat, int updateRate) {
        assert (updateRate > 0) : "updateRate must be greater than zero.";
        this.plat = plat;
        this.updateRate = updateRate;
        plat.frame.connect((Slot)new Slot<Platform>(){

            public void onEmit(Platform plat) {
                Game.this.onFrame();
            }
        });
    }

    public void update(Clock clock) {
        this.update.emit((Object)clock);
    }

    public void paint(Clock clock) {
        this.paint.emit((Object)this.paintClock);
    }

    private void onFrame() {
        int nextUpdate = this.nextUpdate;
        int updateTick = this.plat.tick();
        if (updateTick >= nextUpdate) {
            int updateRate = this.updateRate;
            int updates = 0;
            while (updateTick >= nextUpdate) {
                nextUpdate += updateRate;
                ++updates;
            }
            this.nextUpdate = nextUpdate;
            int updateDt = updates * updateRate;
            this.updateClock.tick += updateDt;
            this.updateClock.dt = updateDt;
            this.update(this.updateClock);
        }
        int paintTick = this.plat.tick();
        this.paintClock.dt = paintTick - this.paintClock.tick;
        this.paintClock.tick = paintTick;
        this.paintClock.alpha = 1.0f - (float)(nextUpdate - paintTick) / (float)this.updateRate;
        this.paint(this.paintClock);
    }
}

