/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.Disposable;
import playn.core.GL20;

public class GLProgram
implements Disposable {
    private final GL20 gl;
    private final int vertexShader;
    private final int fragmentShader;
    public final int id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GLProgram(GL20 gl, String vertexSource, String fragmentSource) {
        this.gl = gl;
        int id = 0;
        int vertexShader = 0;
        int fragmentShader = 0;
        try {
            id = gl.glCreateProgram();
            if (id == 0) {
                throw new RuntimeException("Failed to create program: " + gl.glGetError());
            }
            gl.checkError("glCreateProgram");
            vertexShader = this.compileShader(35633, vertexSource);
            gl.glAttachShader(id, vertexShader);
            gl.checkError("glAttachShader / vertex");
            fragmentShader = this.compileShader(35632, fragmentSource);
            gl.glAttachShader(id, fragmentShader);
            gl.checkError("glAttachShader / fragment");
            gl.glLinkProgram(id);
            int[] linkStatus = new int[1];
            gl.glGetProgramiv(id, 35714, linkStatus, 0);
            if (linkStatus[0] == 0) {
                String log = gl.glGetProgramInfoLog(id);
                gl.glDeleteProgram(id);
                throw new RuntimeException("Failed to link program: " + log);
            }
            this.id = id;
            this.vertexShader = vertexShader;
            this.fragmentShader = fragmentShader;
            fragmentShader = 0;
            vertexShader = 0;
            id = 0;
        }
        finally {
            if (id != 0) {
                gl.glDeleteProgram(id);
            }
            if (vertexShader != 0) {
                gl.glDeleteShader(vertexShader);
            }
            if (fragmentShader != 0) {
                gl.glDeleteShader(fragmentShader);
            }
        }
    }

    public int getUniformLocation(String name) {
        int loc = this.gl.glGetUniformLocation(this.id, name);
        assert (loc >= 0) : "Failed to get " + name + " uniform";
        return loc;
    }

    public int getAttribLocation(String name) {
        int loc = this.gl.glGetAttribLocation(this.id, name);
        assert (loc >= 0) : "Failed to get " + name + " uniform";
        return loc;
    }

    public void activate() {
        this.gl.glUseProgram(this.id);
    }

    @Override
    public void close() {
        this.gl.glDeleteShader(this.vertexShader);
        this.gl.glDeleteShader(this.fragmentShader);
        this.gl.glDeleteProgram(this.id);
    }

    private int compileShader(int type, String shaderSource) {
        int shader = this.gl.glCreateShader(type);
        if (shader == 0) {
            throw new RuntimeException("Failed to create shader (" + type + "): " + this.gl.glGetError());
        }
        this.gl.glShaderSource(shader, shaderSource);
        this.gl.glCompileShader(shader);
        int[] compiled = new int[1];
        this.gl.glGetShaderiv(shader, 35713, compiled, 0);
        if (compiled[0] == 0) {
            String log = this.gl.glGetShaderInfoLog(shader);
            this.gl.glDeleteShader(shader);
            throw new RuntimeException("Failed to compile shader (" + type + "): " + log);
        }
        return shader;
    }
}

