/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.Exec;
import playn.core.Image;
import playn.core.ImageImpl;
import playn.core.Sound;
import react.RFuture;
import react.RPromise;

public abstract class Assets {
    protected final Exec exec;

    public Image getImageSync(String path) {
        ImageImpl image = this.createImage(false, 0, 0);
        try {
            image.succeed(this.load(path));
        }
        catch (Exception e) {
            image.fail(e);
        }
        return image;
    }

    public Image getImage(final String path) {
        final ImageImpl image = this.createImage(true, 0, 0);
        this.exec.invokeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    image.succeed(Assets.this.load(path));
                }
                catch (Exception e) {
                    image.fail(e);
                }
            }
        });
        return image;
    }

    public Image getRemoteImage(String url) {
        return this.getRemoteImage(url, 0, 0);
    }

    public Image getRemoteImage(String url, int width, int height) {
        Exception error = new Exception("Remote image loading not yet supported: " + url + "@" + width + "x" + height);
        ImageImpl image = this.createImage(false, width, height);
        image.fail(error);
        return image;
    }

    public abstract Sound getSound(String var1);

    public Sound getMusic(String path) {
        return this.getSound(path);
    }

    public abstract String getTextSync(String var1) throws Exception;

    public RFuture<String> getText(final String path) {
        final RPromise result = this.exec.deferredPromise();
        this.exec.invokeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    result.succeed((Object)Assets.this.getTextSync(path));
                }
                catch (Throwable t) {
                    result.fail(t);
                }
            }
        });
        return result;
    }

    public abstract byte[] getBytesSync(String var1) throws Exception;

    public RFuture<byte[]> getBytes(final String path) {
        final RPromise result = this.exec.deferredPromise();
        this.exec.invokeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    result.succeed((Object)Assets.this.getBytesSync(path));
                }
                catch (Throwable t) {
                    result.fail(t);
                }
            }
        });
        return result;
    }

    protected Assets(Exec exec) {
        this.exec = exec;
    }

    protected abstract ImageImpl.Data load(String var1) throws Exception;

    protected abstract ImageImpl createImage(boolean var1, int var2, int var3);

    protected static String normalizePath(String path) {
        int pathLen;
        do {
            pathLen = path.length();
        } while ((path = path.replaceAll("[^/]+/\\.\\./", "")).length() != pathLen);
        return path;
    }
}

