/*
 * Decompiled with CFR 0.152.
 */
package playn.bugvm;

import com.bugvm.apple.coregraphics.CGRect;
import com.bugvm.apple.foundation.NSSet;
import com.bugvm.apple.glkit.GLKView;
import com.bugvm.apple.glkit.GLKViewController;
import com.bugvm.apple.glkit.GLKViewControllerDelegate;
import com.bugvm.apple.opengles.EAGLContext;
import com.bugvm.apple.opengles.EAGLRenderingAPI;
import com.bugvm.apple.uikit.UIEvent;
import com.bugvm.apple.uikit.UIInterfaceOrientation;
import com.bugvm.apple.uikit.UIInterfaceOrientationMask;
import com.bugvm.apple.uikit.UITouch;
import com.bugvm.apple.uikit.UIView;
import com.bugvm.objc.Selector;
import com.bugvm.objc.annotation.BindSelector;
import com.bugvm.objc.annotation.Method;
import com.bugvm.rt.bro.annotation.Callback;
import playn.bugvm.BugOrientEvent;
import playn.bugvm.BugPlatform;

public class BugViewController
extends GLKViewController
implements GLKViewControllerDelegate {
    private final GLKView view;
    public final BugPlatform plat;

    public BugViewController(CGRect bounds, BugPlatform.Config config) {
        EAGLContext ctx = new EAGLContext(EAGLRenderingAPI.OpenGLES2);
        EAGLContext.setCurrentContext((EAGLContext)ctx);
        this.plat = new BugPlatform(config, bounds);
        this.view = new GLKView(bounds, ctx){

            @Method(selector="touchesBegan:withEvent:")
            public void touchesBegan(NSSet<UITouch> touches, UIEvent event) {
                BugViewController.this.plat.input().onTouchesBegan(touches, event);
            }

            @Method(selector="touchesCancelled:withEvent:")
            public void touchesCancelled(NSSet<UITouch> touches, UIEvent event) {
                BugViewController.this.plat.input().onTouchesCancelled(touches, event);
            }

            @Method(selector="touchesEnded:withEvent:")
            public void touchesEnded(NSSet<UITouch> touches, UIEvent event) {
                BugViewController.this.plat.input().onTouchesEnded(touches, event);
            }

            @Method(selector="touchesMoved:withEvent:")
            public void touchesMoved(NSSet<UITouch> touches, UIEvent event) {
                BugViewController.this.plat.input().onTouchesMoved(touches, event);
            }
        };
        this.view.setMultipleTouchEnabled(true);
        this.view.setDrawableColorFormat(this.plat.config.glBufferFormat);
        this.setView((UIView)this.view);
        this.setDelegate(this);
        this.setPreferredFramesPerSecond(config.targetFPS);
        this.addStrongRef((Object)this.plat);
    }

    public void update(GLKViewController self) {
        this.plat.processFrame();
    }

    public void willPause(GLKViewController self, boolean paused) {
        if (paused) {
            this.plat.didEnterBackground();
        } else {
            this.view.bindDrawable();
            this.plat.willEnterForeground();
        }
    }

    public void viewDidAppear(boolean animated) {
        super.viewDidAppear(animated);
        this.view.bindDrawable();
        this.plat.graphics().viewDidInit(this.getView().getBounds());
    }

    public void viewDidDisappear(boolean animated) {
        super.viewDidDisappear(animated);
        EAGLContext.setCurrentContext(null);
    }

    public void willRotate(UIInterfaceOrientation toOrient, double duration) {
        super.willRotate(toOrient, duration);
        this.plat.orient.emit((Object)new BugOrientEvent.WillRotate(toOrient, duration));
    }

    public void didRotate(UIInterfaceOrientation fromOrient) {
        super.didRotate(fromOrient);
        this.plat.graphics().boundsChanged(this.getView().getBounds());
        this.plat.orient.emit((Object)new BugOrientEvent.DidRotate(fromOrient));
    }

    public UIInterfaceOrientationMask getSupportedInterfaceOrientations() {
        return this.plat.config.orients;
    }

    public boolean shouldAutorotate() {
        return true;
    }

    public boolean shouldAutorotateToInterfaceOrientation(UIInterfaceOrientation orientation) {
        return true;
    }

    protected void doDispose() {
        this.plat.willTerminate();
        this.removeStrongRef((Object)this.plat);
        super.doDispose();
    }

    @Callback
    @BindSelector(value="shouldAutorotateToInterfaceOrientation:")
    private static boolean shouldAutorotateToInterfaceOrientation(BugViewController self, Selector sel, UIInterfaceOrientation orientation) {
        return self.shouldAutorotateToInterfaceOrientation(orientation);
    }
}

