/*
 * Decompiled with CFR 0.152.
 */
package playn.bugvm;

import com.bugvm.apple.foundation.NSFileManager;
import com.bugvm.apple.foundation.NSSearchPathDirectory;
import com.bugvm.apple.foundation.NSSearchPathDomainMask;
import com.bugvm.apple.foundation.NSURL;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import playn.bugvm.BugPlatform;
import playn.core.BatchImpl;
import playn.core.Storage;

public class BugStorage
implements Storage {
    private final BugPlatform platform;
    private final Connection conn;

    public BugStorage(BugPlatform platform) {
        this.platform = platform;
        String dbDir = null;
        try {
            try {
                Class.forName("SQLite.JDBCDriver");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            dbDir = ((NSURL)NSFileManager.getDefaultManager().getURLsForDirectory(NSSearchPathDirectory.DocumentDirectory, NSSearchPathDomainMask.UserDomainMask).get(0)).getPath();
            File dbFile = new File(dbDir, platform.config.storageFileName);
            dbFile.getParentFile().mkdirs();
            platform.log().info("Using db in file: " + dbFile.getAbsolutePath());
            this.conn = DriverManager.getConnection("jdbc:sqlite:" + dbFile.getAbsolutePath());
            try (Statement stmt = this.conn.createStatement();){
                stmt.executeUpdate("CREATE TABLE IF NOT EXISTS Data (DataKey ntext PRIMARY KEY, DataValue ntext NOT NULL)");
            }
        }
        catch (SQLException sqe) {
            throw new RuntimeException("Failed to initialize storage [dbDir=" + dbDir + "]", sqe);
        }
    }

    public boolean isPersisted() {
        return true;
    }

    public Iterable<String> keys() {
        try {
            ArrayList<String> keys = new ArrayList<String>();
            try (Statement stmt = this.conn.createStatement();){
                ResultSet rs = stmt.executeQuery("select DataKey from Data");
                while (rs.next()) {
                    keys.add(rs.getString(1));
                }
            }
            return keys;
        }
        catch (SQLException sqe) {
            throw new RuntimeException("keys() failed", sqe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getItem(String key) {
        try {
            String sql = "select DataValue from Data where DataKey = ?";
            try (PreparedStatement stmt = this.conn.prepareStatement(sql);){
                stmt.setString(1, key);
                ResultSet rs = stmt.executeQuery();
                String result = null;
                while (rs.next()) {
                    result = rs.getString(1);
                }
                String string = result;
                return string;
            }
        }
        catch (SQLException sqe) {
            throw new RuntimeException("getItem(" + key + ") failed", sqe);
        }
    }

    public void setItem(String key, String value) throws RuntimeException {
        try {
            String usql = "update Data set DataValue = ? where DataKey = ?";
            try (PreparedStatement ustmt = this.conn.prepareStatement(usql);){
                ustmt.setString(1, value);
                ustmt.setString(2, key);
                if (ustmt.executeUpdate() > 0) {
                    return;
                }
            }
            String isql = "insert into Data (DataKey, DataValue) values (?, ?)";
            try (PreparedStatement istmt = this.conn.prepareStatement(isql);){
                istmt.setString(1, key);
                istmt.setString(2, value);
                if (istmt.executeUpdate() == 0) {
                    this.platform.log().warn("Failed to insert storage item [key=" + key + "]");
                }
            }
        }
        catch (SQLException sqe) {
            throw new RuntimeException("setItem(" + key + ", " + value + ") failed", sqe);
        }
    }

    public void removeItem(String key) {
        try {
            String sql = "delete from Data where DataKey = ?";
            try (PreparedStatement stmt = this.conn.prepareStatement(sql);){
                stmt.setString(1, key);
                stmt.executeUpdate();
            }
        }
        catch (SQLException sqe) {
            throw new RuntimeException("removeItem(" + key + ") failed", sqe);
        }
    }

    public Storage.Batch startBatch() {
        return new BatchImpl((Storage)this);
    }
}

