/*
 * Decompiled with CFR 0.152.
 */
package playn.bugvm;

import com.bugvm.apple.coregraphics.CGRect;
import com.bugvm.apple.foundation.NSTimer;
import com.bugvm.apple.foundation.NSURL;
import com.bugvm.apple.glkit.GLKViewDrawableColorFormat;
import com.bugvm.apple.opengles.EAGLContext;
import com.bugvm.apple.uikit.UIApplication;
import com.bugvm.apple.uikit.UIDevice;
import com.bugvm.apple.uikit.UIInterfaceOrientationMask;
import com.bugvm.apple.uikit.UIViewController;
import com.bugvm.apple.uikit.UIWindow;
import com.bugvm.objc.block.VoidBlock1;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import playn.bugvm.BugAssets;
import playn.bugvm.BugAudio;
import playn.bugvm.BugGraphics;
import playn.bugvm.BugInput;
import playn.bugvm.BugLog;
import playn.bugvm.BugNet;
import playn.bugvm.BugOrientEvent;
import playn.bugvm.BugStorage;
import playn.bugvm.BugViewController;
import playn.core.Exec;
import playn.core.Json;
import playn.core.Log;
import playn.core.Net;
import playn.core.Platform;
import playn.core.Storage;
import playn.core.json.JsonImpl;
import react.Signal;

public class BugPlatform
extends Platform {
    public Signal<BugOrientEvent> orient = Signal.create();
    final int osVersion = this.getOSVersion();
    final Config config;
    private boolean paused = false;
    private final long gameStart = System.nanoTime();
    private final ExecutorService pool = Executors.newFixedThreadPool(3);
    private final BugLog log = new BugLog();
    private final Json json = new JsonImpl();
    private final Exec exec = new Exec.Default(this){

        public boolean isAsyncSupported() {
            return true;
        }

        public void invokeAsync(Runnable action) {
            BugPlatform.this.pool.execute(action);
        }
    };
    private BugAudio audio;
    private final BugAssets assets;
    private final BugGraphics graphics;
    private final BugInput input;
    private final BugNet net;
    private final BugStorage storage;

    public static BugPlatform create(UIWindow window, Config config) {
        BugViewController ctrl = new BugViewController(window.getBounds(), config);
        window.setRootViewController((UIViewController)ctrl);
        return ctrl.plat;
    }

    protected BugPlatform(Config config, CGRect initBounds) {
        this.config = config;
        this.assets = new BugAssets(this);
        this.graphics = new BugGraphics(this, config, initBounds);
        this.input = new BugInput(this);
        this.net = new BugNet(this.exec);
        this.storage = new BugStorage(this);
    }

    public Platform.Type type() {
        return Platform.Type.IOS;
    }

    public double time() {
        return System.currentTimeMillis();
    }

    public int tick() {
        return (int)((System.nanoTime() - this.gameStart) / 1000000L);
    }

    public void openURL(String url) {
        if (!UIApplication.getSharedApplication().openURL(new NSURL(url))) {
            this.log().warn("Failed to open URL: " + url);
        }
    }

    public BugAssets assets() {
        return this.assets;
    }

    public BugAudio audio() {
        if (this.audio == null) {
            this.audio = new BugAudio(this, this.config.openALSources);
        }
        return this.audio;
    }

    public Exec exec() {
        return this.exec;
    }

    public Json json() {
        return this.json;
    }

    public Log log() {
        return this.log;
    }

    public Net net() {
        return this.net;
    }

    public BugGraphics graphics() {
        return this.graphics;
    }

    public BugInput input() {
        return this.input;
    }

    public Storage storage() {
        return this.storage;
    }

    void processFrame() {
        this.emitFrame();
    }

    void willEnterForeground() {
        if (!this.paused) {
            return;
        }
        this.paused = false;
        this.exec.invokeLater(new Runnable(){

            @Override
            public void run() {
                BugPlatform.this.dispatchEvent(BugPlatform.this.lifecycle, Platform.Lifecycle.RESUME);
            }
        });
    }

    void didEnterBackground() {
        if (this.paused) {
            return;
        }
        this.paused = true;
        this.dispatchEvent(this.lifecycle, Platform.Lifecycle.PAUSE);
    }

    void willTerminate() {
        new NSTimer((double)this.config.timeForTermination, (VoidBlock1)new VoidBlock1<NSTimer>(){

            public void invoke(NSTimer timer) {
                EAGLContext.setCurrentContext(null);
                if (BugPlatform.this.audio != null) {
                    BugPlatform.this.audio.terminate();
                }
            }
        }, null, false);
        this.dispatchEvent(this.lifecycle, Platform.Lifecycle.EXIT);
    }

    private int getOSVersion() {
        String systemVersion = UIDevice.getCurrentDevice().getSystemVersion();
        int version = Integer.parseInt(systemVersion.split("\\.")[0]);
        return version;
    }

    public static class Config {
        public UIInterfaceOrientationMask orients = UIInterfaceOrientationMask.Portrait;
        public boolean iPadLikePhone = false;
        public int frameInterval = 1;
        public boolean interpolateCanvasDrawing = true;
        public int openALSources = 24;
        public float timeForTermination = 0.5f;
        public GLKViewDrawableColorFormat glBufferFormat = GLKViewDrawableColorFormat.RGBA8888;
        public int targetFPS = 60;
        public String storageFileName = "playn.db";
    }
}

