/*
 * Decompiled with CFR 0.152.
 */
package playn.bugvm;

import com.bugvm.apple.coregraphics.CGPoint;
import com.bugvm.apple.foundation.NSSet;
import com.bugvm.apple.uikit.UIAlertView;
import com.bugvm.apple.uikit.UIAlertViewDelegate;
import com.bugvm.apple.uikit.UIAlertViewDelegateAdapter;
import com.bugvm.apple.uikit.UIAlertViewStyle;
import com.bugvm.apple.uikit.UIEvent;
import com.bugvm.apple.uikit.UIKeyboardType;
import com.bugvm.apple.uikit.UIReturnKeyType;
import com.bugvm.apple.uikit.UITextAutocapitalizationType;
import com.bugvm.apple.uikit.UITextAutocorrectionType;
import com.bugvm.apple.uikit.UITextField;
import com.bugvm.apple.uikit.UITouch;
import playn.bugvm.BugPlatform;
import playn.core.Input;
import playn.core.Keyboard;
import playn.core.Platform;
import playn.core.Touch;
import pythagoras.f.IPoint;
import react.RFuture;
import react.RPromise;

public class BugInput
extends Input {
    private final BugPlatform plat;

    public BugInput(BugPlatform plat) {
        super((Platform)plat);
        this.plat = plat;
    }

    public boolean hasTouch() {
        return true;
    }

    public RFuture<String> getText(Keyboard.TextType textType, String label, String initVal) {
        final RPromise result = this.plat.exec().deferredPromise();
        UIAlertView view = new UIAlertView();
        if (label != null) {
            view.setTitle(label);
        }
        view.addButton("Cancel");
        view.addButton("OK");
        view.setAlertViewStyle(UIAlertViewStyle.PlainTextInput);
        final UITextField field = view.getTextField(0L);
        field.setReturnKeyType(UIReturnKeyType.Done);
        if (initVal != null) {
            field.setText(initVal);
        }
        switch (textType) {
            case NUMBER: {
                field.setKeyboardType(UIKeyboardType.NumberPad);
                break;
            }
            case EMAIL: {
                field.setKeyboardType(UIKeyboardType.EmailAddress);
                break;
            }
            case URL: {
                field.setKeyboardType(UIKeyboardType.URL);
                break;
            }
            case DEFAULT: {
                field.setKeyboardType(UIKeyboardType.Default);
            }
        }
        field.setAutocorrectionType(UITextAutocorrectionType.Yes);
        field.setAutocapitalizationType(UITextAutocapitalizationType.Sentences);
        field.setSecureTextEntry(false);
        view.setDelegate((UIAlertViewDelegate)new UIAlertViewDelegateAdapter(){

            public void clicked(UIAlertView view, long buttonIndex) {
                result.succeed(buttonIndex == 0L ? null : field.getText());
            }
        });
        view.show();
        return result;
    }

    public RFuture<Boolean> sysDialog(String title, String text, String ok, String cancel) {
        final RPromise result = this.plat.exec().deferredPromise();
        UIAlertView view = new UIAlertView();
        view.setTitle(title);
        view.setMessage(text);
        if (cancel != null) {
            view.addButton(cancel);
        }
        view.addButton(ok);
        view.setAlertViewStyle(UIAlertViewStyle.Default);
        view.setDelegate((UIAlertViewDelegate)new UIAlertViewDelegateAdapter(){

            public void clicked(UIAlertView view, long buttonIndex) {
                result.succeed((Object)(buttonIndex == 1L ? 1 : 0));
            }
        });
        view.show();
        return result;
    }

    void onTouchesBegan(NSSet<UITouch> touches, UIEvent event) {
        this.plat.dispatchEvent(this.touchEvents, this.toEvents(touches, event, Touch.Event.Kind.START));
    }

    void onTouchesMoved(NSSet<UITouch> touches, UIEvent event) {
        this.plat.dispatchEvent(this.touchEvents, this.toEvents(touches, event, Touch.Event.Kind.MOVE));
    }

    void onTouchesEnded(NSSet<UITouch> touches, UIEvent event) {
        this.plat.dispatchEvent(this.touchEvents, this.toEvents(touches, event, Touch.Event.Kind.END));
    }

    void onTouchesCancelled(NSSet<UITouch> touches, UIEvent event) {
        this.plat.dispatchEvent(this.touchEvents, this.toEvents(touches, event, Touch.Event.Kind.CANCEL));
    }

    private Touch.Event[] toEvents(NSSet<UITouch> touches, UIEvent event, Touch.Event.Kind kind) {
        Touch.Event[] events = new Touch.Event[touches.size()];
        int idx = 0;
        for (UITouch touch : touches) {
            CGPoint loc = touch.getLocationInView(touch.getView());
            IPoint xloc = this.plat.graphics().transformTouch((float)loc.getX(), (float)loc.getY());
            int id = (int)touch.getHandle();
            events[idx++] = new Touch.Event(0, touch.getTimestamp() * 1000.0, xloc.x(), xloc.y(), kind, id);
        }
        return events;
    }
}

