/*
 * Decompiled with CFR 0.152.
 */
package playn.bugvm;

import com.bugvm.apple.coregraphics.CGBitmapContext;
import com.bugvm.apple.coregraphics.CGBitmapInfo;
import com.bugvm.apple.coregraphics.CGColorSpace;
import com.bugvm.apple.coregraphics.CGImageAlphaInfo;
import com.bugvm.apple.coregraphics.CGRect;
import com.bugvm.apple.uikit.UIDevice;
import com.bugvm.apple.uikit.UIScreen;
import com.bugvm.apple.uikit.UIUserInterfaceIdiom;
import playn.bugvm.BugCanvas;
import playn.bugvm.BugCanvasImage;
import playn.bugvm.BugGL20;
import playn.bugvm.BugPlatform;
import playn.bugvm.BugTextLayout;
import playn.core.Canvas;
import playn.core.GL20;
import playn.core.Graphics;
import playn.core.Platform;
import playn.core.Scale;
import playn.core.TextFormat;
import playn.core.TextLayout;
import playn.core.TextWrap;
import pythagoras.f.Dimension;
import pythagoras.f.IDimension;
import pythagoras.f.IPoint;
import pythagoras.f.Point;

public class BugGraphics
extends Graphics {
    static final CGColorSpace colorSpace = CGColorSpace.createDeviceRGB();
    final Platform plat;
    private final BugPlatform.Config config;
    private final float touchScale;
    private final Point touchTemp = new Point();
    private final Dimension screenSize = new Dimension();
    private int defaultFramebuffer;
    private static final int S_SIZE = 10;
    final CGBitmapContext scratchCtx = BugGraphics.createCGBitmap(10, 10);

    private static boolean useHalfSize(BugPlatform.Config config) {
        boolean isPad = UIDevice.getCurrentDevice().getUserInterfaceIdiom() == UIUserInterfaceIdiom.Pad;
        return isPad && config.iPadLikePhone;
    }

    private static Scale viewScale(BugPlatform.Config config) {
        float deviceScale = (float)UIScreen.getMainScreen().getScale();
        boolean useHalfSize = BugGraphics.useHalfSize(config);
        return new Scale((float)(useHalfSize ? 2 : 1) * deviceScale);
    }

    public BugGraphics(Platform plat, BugPlatform.Config config, CGRect bounds) {
        super(plat, (GL20)new BugGL20(), BugGraphics.viewScale(config));
        this.plat = plat;
        this.config = config;
        this.touchScale = BugGraphics.useHalfSize(config) ? 2.0f : 1.0f;
        this.boundsChanged(bounds);
    }

    public IDimension screenSize() {
        CGRect screenBounds = UIScreen.getMainScreen().getBounds();
        this.screenSize.width = (int)screenBounds.getWidth();
        this.screenSize.height = (int)screenBounds.getHeight();
        if (BugGraphics.useHalfSize(this.config)) {
            this.screenSize.width /= 2.0f;
            this.screenSize.height /= 2.0f;
        }
        return this.screenSize;
    }

    public TextLayout layoutText(String text, TextFormat format) {
        return BugTextLayout.layoutText(this, text, format);
    }

    public TextLayout[] layoutText(String text, TextFormat format, TextWrap wrap) {
        return BugTextLayout.layoutText(this, text, format, wrap);
    }

    protected int defaultFramebuffer() {
        return this.defaultFramebuffer;
    }

    protected Canvas createCanvasImpl(Scale scale, int pixelWidth, int pixelHeight) {
        return new BugCanvas(this, new BugCanvasImage((Graphics)this, scale, pixelWidth, pixelHeight, this.config.interpolateCanvasDrawing));
    }

    static CGBitmapContext createCGBitmap(int width, int height) {
        return CGBitmapContext.create((long)width, (long)height, (long)8L, (long)(4 * width), (CGColorSpace)colorSpace, (CGBitmapInfo)new CGBitmapInfo(CGImageAlphaInfo.PremultipliedLast.value()));
    }

    void viewDidInit(CGRect bounds) {
        this.defaultFramebuffer = this.gl.glGetInteger(36006);
        if (this.defaultFramebuffer == 0) {
            throw new IllegalStateException("Failed to determine defaultFramebuffer");
        }
        this.boundsChanged(bounds);
    }

    void boundsChanged(CGRect bounds) {
        this.viewportChanged(this.scale().scaledCeil((float)bounds.getWidth()), this.scale().scaledCeil((float)bounds.getHeight()));
    }

    IPoint transformTouch(float x, float y) {
        return this.touchTemp.set(x / this.touchScale, y / this.touchScale);
    }
}

