/*
 * Decompiled with CFR 0.152.
 */
package playn.bugvm;

import com.bugvm.apple.coregraphics.CGAffineTransform;
import com.bugvm.apple.coretext.CTFont;
import java.util.HashMap;
import java.util.Map;
import playn.core.Font;

public class BugFont {
    private static Map<Font, CTFont> fonts = new HashMap<Font, CTFont>();
    private static Map<Font.Style, Map<String, String>> _variants = new HashMap<Font.Style, Map<String, String>>();
    private static final Font DEFAULT_FONT;

    public static void registerVariant(String name, Font.Style style, String variantName) {
        Map<String, String> styleVariants = _variants.get(style);
        if (styleVariants == null) {
            styleVariants = new HashMap<String, String>();
            _variants.put(style, styleVariants);
        }
        styleVariants.put(name, variantName);
    }

    static CTFont resolveFont(Font font) {
        CTFont ctFont = fonts.get(font == null ? DEFAULT_FONT : font);
        if (ctFont == null) {
            String iosName = BugFont.getVariant(font.name, font.style);
            ctFont = CTFont.create((String)iosName, (double)font.size, (CGAffineTransform)CGAffineTransform.Identity());
            fonts.put(font, ctFont);
        }
        return ctFont;
    }

    private static String getVariant(String name, Font.Style style) {
        String variant;
        Map<String, String> styleVariants = _variants.get(style);
        String string = variant = styleVariants == null ? null : styleVariants.get(name);
        if (variant != null) {
            return variant;
        }
        if (style == Font.Style.BOLD_ITALIC) {
            return BugFont.getVariant(name, Font.Style.BOLD);
        }
        return name;
    }

    static {
        BugFont.registerVariant("American Typewriter", Font.Style.PLAIN, "AmericanTypewriter");
        BugFont.registerVariant("American Typewriter", Font.Style.BOLD, "AmericanTypewriter-Bold");
        BugFont.registerVariant("Arial", Font.Style.PLAIN, "ArialMT");
        BugFont.registerVariant("Arial", Font.Style.ITALIC, "Arial-ItalicMT");
        BugFont.registerVariant("Arial", Font.Style.BOLD, "Arial-BoldMT");
        BugFont.registerVariant("Arial", Font.Style.BOLD_ITALIC, "Arial-BoldItalicMT");
        BugFont.registerVariant("Arial Hebrew", Font.Style.PLAIN, "ArialHebrew");
        BugFont.registerVariant("Arial Hebrew", Font.Style.BOLD, "ArialHebrew-Bold");
        BugFont.registerVariant("Baskerville", Font.Style.BOLD, "Baskerville-Bold");
        BugFont.registerVariant("Baskerville", Font.Style.ITALIC, "Baskerville-Italic");
        BugFont.registerVariant("Baskerville", Font.Style.BOLD_ITALIC, "Baskerville-BoldItalic");
        BugFont.registerVariant("Chalkboard SE", Font.Style.PLAIN, "ChalkboardSE-Regular");
        BugFont.registerVariant("Chalkboard SE", Font.Style.BOLD, "ChalkboardSE-Bold");
        BugFont.registerVariant("Cochin", Font.Style.BOLD, "Cochin-Bold");
        BugFont.registerVariant("Cochin", Font.Style.ITALIC, "Cochin-Italic");
        BugFont.registerVariant("Cochin", Font.Style.BOLD_ITALIC, "Cochin-BoldItalic");
        BugFont.registerVariant("Courier", Font.Style.BOLD, "Courier-Bold");
        BugFont.registerVariant("Courier", Font.Style.ITALIC, "Courier-Oblique");
        BugFont.registerVariant("Courier", Font.Style.BOLD_ITALIC, "Courier-BoldOblique");
        BugFont.registerVariant("Courier New", Font.Style.PLAIN, "CourierNewPSMT");
        BugFont.registerVariant("Courier New", Font.Style.BOLD, "CourierNewPS-BoldMT");
        BugFont.registerVariant("Courier New", Font.Style.ITALIC, "CourierNewPS-ItalicMT");
        BugFont.registerVariant("Courier New", Font.Style.BOLD_ITALIC, "CourierNewPS-BoldItalicMT");
        BugFont.registerVariant("Georgia", Font.Style.ITALIC, "Georgia-Italic");
        BugFont.registerVariant("Georgia", Font.Style.BOLD, "Georgia-Bold");
        BugFont.registerVariant("Georgia", Font.Style.BOLD_ITALIC, "Georgia-BoldItalic");
        BugFont.registerVariant("Helvetica", Font.Style.BOLD, "Helvetica-Bold");
        BugFont.registerVariant("Helvetica", Font.Style.ITALIC, "Helvetica-Oblique");
        BugFont.registerVariant("Helvetica", Font.Style.BOLD_ITALIC, "Helvetica-Bold-Oblique");
        BugFont.registerVariant("Helvetica Neue", Font.Style.PLAIN, "HelveticaNeue");
        BugFont.registerVariant("Helvetica Neue", Font.Style.BOLD, "HelveticaNeue-Bold");
        BugFont.registerVariant("Helvetica Neue", Font.Style.ITALIC, "HelveticaNeue-Italic");
        BugFont.registerVariant("Helvetica Neue", Font.Style.BOLD_ITALIC, "HelveticaNeue-BoldItalic");
        BugFont.registerVariant("Palatino", Font.Style.PLAIN, "Palatino-Romain");
        BugFont.registerVariant("Palatino", Font.Style.ITALIC, "Palatino-Italic");
        BugFont.registerVariant("Palatino", Font.Style.BOLD, "Palatino-Bold");
        BugFont.registerVariant("Palatino", Font.Style.BOLD_ITALIC, "Palatino-BoldItalic");
        BugFont.registerVariant("Times New Roman", Font.Style.PLAIN, "TimesNewRomanPSMT");
        BugFont.registerVariant("Times New Roman", Font.Style.ITALIC, "TimesNewRomanPS-ItalicMT");
        BugFont.registerVariant("Times New Roman", Font.Style.BOLD, "TimesNewRomanPS-BoldMT");
        BugFont.registerVariant("Times New Roman", Font.Style.BOLD_ITALIC, "TimesNewRomanPS-BoldItalicMT");
        BugFont.registerVariant("Trebuchet MS", Font.Style.PLAIN, "TrebuchetMS");
        BugFont.registerVariant("Trebuchet MS", Font.Style.ITALIC, "TrebuchetMS-Italic");
        BugFont.registerVariant("Trebuchet MS", Font.Style.BOLD, "TrebuchetMS-Bold");
        BugFont.registerVariant("Trebuchet MS", Font.Style.BOLD_ITALIC, "Trebuchet-BoldItalic");
        BugFont.registerVariant("Verdana", Font.Style.ITALIC, "Verdana-Italic");
        BugFont.registerVariant("Verdana", Font.Style.BOLD, "Verdana-Bold");
        BugFont.registerVariant("Verdana", Font.Style.BOLD_ITALIC, "Verdana-BoldItalic");
        BugFont.registerVariant("Times", Font.Style.PLAIN, "TimesNewRomanPSMT");
        BugFont.registerVariant("Times", Font.Style.ITALIC, "TimesNewRomanPS-ItalicMT");
        BugFont.registerVariant("Times", Font.Style.BOLD, "TimesNewRomanPS-BoldMT");
        BugFont.registerVariant("Times", Font.Style.BOLD_ITALIC, "TimesNewRomanPS-BoldItalicMT");
        DEFAULT_FONT = new Font("Helvetica", Font.Style.PLAIN, 12.0f);
    }
}

