/*
 * Decompiled with CFR 0.152.
 */
package playn.bugvm;

import com.bugvm.apple.coregraphics.CGBitmapContext;
import com.bugvm.apple.coregraphics.CGImage;
import com.bugvm.apple.coregraphics.CGInterpolationQuality;
import playn.bugvm.BugGraphics;
import playn.bugvm.BugImage;
import playn.core.Graphics;
import playn.core.Scale;
import playn.core.Texture;

public class BugCanvasImage
extends BugImage {
    CGBitmapContext bctx;

    public BugCanvasImage(Graphics gfx, Scale scale, int pixelWidth, int pixelHeight, boolean interpolate) {
        super(gfx, scale, pixelWidth, pixelHeight, "<canvas>");
        this.bctx = BugGraphics.createCGBitmap(pixelWidth, pixelHeight);
        if (!interpolate) {
            this.bctx.setInterpolationQuality(CGInterpolationQuality.None);
        }
    }

    @Override
    public CGImage cgImage() {
        return this.bctx.toImage();
    }

    @Override
    protected void upload(Graphics gfx, Texture tex) {
        this.upload(gfx, tex.id, this.pixelWidth, this.pixelHeight, this.bctx.getData());
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.bctx != null) {
            this.bctx.dispose();
            this.bctx = null;
        }
    }
}

