/*
 * Decompiled with CFR 0.152.
 */
package playn.bugvm;

import com.bugvm.apple.avfoundation.AVAudioPlayer;
import com.bugvm.apple.avfoundation.AVAudioSession;
import com.bugvm.apple.avfoundation.AVAudioSessionSetActiveOptions;
import com.bugvm.apple.foundation.NSErrorException;
import com.bugvm.apple.foundation.NSURL;
import java.io.File;
import playn.bugvm.BugPlatform;
import playn.bugvm.BugSoundAVAP;
import playn.bugvm.BugSoundOAL;
import playn.bugvm.CAFLoader;
import playn.bugvm.OpenAL;
import playn.core.Audio;
import playn.core.Sound;

public class BugAudio
extends Audio {
    private final BugPlatform plat;
    private final AVAudioSession session;
    private final long oalDevice;
    private final long oalContext;
    private final int[] sources;
    private final BugSoundOAL[] active;
    private final int[] started;

    public BugAudio(BugPlatform plat, int numSources) {
        this.plat = plat;
        this.session = AVAudioSession.getSharedInstance();
        try {
            this.session.setActive(true, AVAudioSessionSetActiveOptions.None);
        }
        catch (NSErrorException e) {
            plat.log().error("Unable to activate audio session: " + (Object)((Object)e));
        }
        this.oalDevice = OpenAL.alcOpenDevice(null);
        if (this.oalDevice != 0L) {
            this.oalContext = OpenAL.alcCreateContext(this.oalDevice, null);
            OpenAL.alcMakeContextCurrent(this.oalContext);
        } else {
            plat.log().warn("Unable to open OpenAL device. Disabling OAL sound.");
            this.oalContext = 0L;
        }
        this.sources = new int[numSources];
        OpenAL.alGenSources(numSources, this.sources);
        this.active = new BugSoundOAL[this.sources.length];
        this.started = new int[this.sources.length];
    }

    public Sound createSound(File path, boolean isMusic) {
        return isMusic || !path.getName().endsWith(".caf") ? this.createAVAP(new NSURL(path)) : this.createOAL(path);
    }

    Sound createAVAP(final NSURL url) {
        final BugSoundAVAP sound = new BugSoundAVAP(this.plat);
        this.plat.exec().invokeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    sound.succeed(new AVAudioPlayer(url));
                }
                catch (Exception e) {
                    BugAudio.this.plat.log().warn("Error loading sound [" + url + "]", (Throwable)e);
                    sound.fail(e);
                }
            }
        });
        return sound;
    }

    Sound createOAL(final File assetPath) {
        final BugSoundOAL sound = new BugSoundOAL(this.plat);
        this.plat.exec().invokeAsync(new Runnable(){

            @Override
            public void run() {
                int bufferId = 0;
                try {
                    bufferId = OpenAL.alGenBuffer();
                    CAFLoader.load(assetPath, bufferId);
                    sound.succeed(bufferId);
                }
                catch (Throwable t) {
                    if (bufferId != 0) {
                        OpenAL.alDeleteBuffer(bufferId);
                    }
                    sound.fail(t);
                }
            }
        });
        return sound;
    }

    boolean isPlaying(int sourceIdx, BugSoundOAL sound) {
        if (this.active[sourceIdx] != sound) {
            return false;
        }
        int[] result = new int[1];
        OpenAL.alGetSourcei(this.sources[sourceIdx], 4112, result);
        return result[0] == 4114;
    }

    int play(BugSoundOAL sound, float volume, boolean looping) {
        int sourceIdx = -1;
        int eldestIdx = 0;
        for (int ii = 0; ii < this.sources.length; ++ii) {
            if (!this.isPlaying(ii, this.active[ii])) {
                sourceIdx = ii;
                break;
            }
            if (this.started[ii] >= this.started[eldestIdx]) continue;
            eldestIdx = ii;
        }
        if (sourceIdx < 0) {
            this.stop(eldestIdx, this.active[eldestIdx]);
            sourceIdx = eldestIdx;
        }
        int sourceId = this.sources[sourceIdx];
        OpenAL.alSourcei(sourceId, 4105, sound.bufferId());
        OpenAL.alSourcef(sourceId, 4106, volume);
        OpenAL.alSourcei(sourceId, 4103, looping ? 1 : 0);
        OpenAL.alSourcePlay(sourceId);
        this.active[sourceIdx] = sound;
        this.started[sourceIdx] = this.plat.tick();
        return sourceIdx;
    }

    void stop(int sourceIdx, BugSoundOAL sound) {
        if (this.active[sourceIdx] == sound) {
            OpenAL.alSourceStop(this.sources[sourceIdx]);
        }
    }

    void delete(BugSoundOAL sound) {
        OpenAL.alDeleteBuffer(sound.bufferId());
    }

    void setLooping(int sourceIdx, BugSoundOAL sound, boolean looping) {
        if (this.active[sourceIdx] == sound) {
            OpenAL.alSourcei(this.sources[sourceIdx], 4103, looping ? 1 : 0);
        }
    }

    void setVolume(int sourceIdx, BugSoundOAL sound, float volume) {
        if (this.active[sourceIdx] == sound) {
            OpenAL.alSourcef(this.sources[sourceIdx], 4106, volume);
        }
    }

    void terminate() {
    }
}

