/*
 * Decompiled with CFR 0.152.
 */
package playn.android;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.view.MotionEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import playn.android.AndroidPlatform;

public class GameViewGL
extends GLSurfaceView {
    private final AndroidPlatform plat;
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicBoolean paused = new AtomicBoolean(true);

    public GameViewGL(Context context, AndroidPlatform platform) {
        super(context);
        this.plat = platform;
        this.setFocusable(true);
        this.setEGLContextClientVersion(2);
        this.setPreserveEGLContextOnPause(true);
        this.setRenderer(new GLSurfaceView.Renderer(){

            public void onSurfaceCreated(GL10 gl, EGLConfig config) {
                GameViewGL.this.plat.graphics().onSurfaceCreated();
            }

            public void onSurfaceChanged(GL10 gl, int width, int height) {
                GameViewGL.this.plat.graphics().onSurfaceChanged(width, height);
                if (!GameViewGL.this.started.get()) {
                    GameViewGL.this.startGame();
                }
            }

            public void onDrawFrame(GL10 gl) {
                if (!GameViewGL.this.paused.get()) {
                    GameViewGL.this.plat.processFrame();
                }
            }
        });
        this.setRenderMode(1);
    }

    public void onPause() {
        this.paused.set(true);
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                GameViewGL.this.plat.graphics().onSurfaceLost();
            }
        });
        super.onPause();
    }

    public void onResume() {
        super.onResume();
        this.paused.set(false);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.plat.input().onTouch(event);
    }

    void startGame() {
        this.started.set(true);
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((GameViewGL)GameViewGL.this).plat.activity.main();
                GameViewGL.this.paused.set(false);
            }
        });
    }
}

