/*
 * Decompiled with CFR 0.152.
 */
package playn.android;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import java.util.ArrayList;
import playn.android.AndroidFont;
import playn.android.AndroidGraphics;
import playn.core.TextFormat;
import playn.core.TextLayout;
import playn.core.TextWrap;
import pythagoras.f.IRectangle;
import pythagoras.f.Rectangle;

class AndroidTextLayout
extends TextLayout {
    private final AndroidFont font;
    private final Paint.FontMetrics metrics;

    public static TextLayout layoutText(AndroidGraphics gfx, String text, TextFormat format) {
        AndroidFont font = gfx.resolveFont(format.font);
        Paint paint = new Paint(format.antialias ? 1 : 0);
        paint.setTypeface(font.typeface);
        paint.setTextSize(font.size);
        paint.setSubpixelText(true);
        Paint.FontMetrics metrics = paint.getFontMetrics();
        return new AndroidTextLayout(text, format, font, metrics, paint.measureText(text));
    }

    public static TextLayout[] layoutText(AndroidGraphics gfx, String text, TextFormat format, TextWrap wrap) {
        AndroidFont font = gfx.resolveFont(format.font);
        Paint paint = new Paint(format.antialias ? 1 : 0);
        paint.setTypeface(font.typeface);
        paint.setTextSize(font.size);
        paint.setSubpixelText(true);
        Paint.FontMetrics metrics = paint.getFontMetrics();
        ArrayList<AndroidTextLayout> layouts = new ArrayList<AndroidTextLayout>();
        float[] measuredWidth = new float[1];
        for (String ltext : AndroidTextLayout.normalizeEOL((String)text).split("\\n")) {
            if (wrap.width <= 0.0f || wrap.width == Float.MAX_VALUE) {
                layouts.add(new AndroidTextLayout(ltext, format, font, metrics, paint.measureText(ltext)));
                continue;
            }
            int start = 0;
            int end = ltext.length();
            while (start < end) {
                int count = paint.breakText((CharSequence)ltext, start, end, true, wrap.width, measuredWidth);
                int lineEnd = start + count;
                if (lineEnd < end && font.ligatureHacks.length > 0) {
                    int adjust = AndroidTextLayout.accountForLigatures(ltext, start, count, font.ligatureHacks);
                    count += adjust;
                    lineEnd += adjust;
                }
                if (lineEnd == end) {
                    layouts.add(new AndroidTextLayout(ltext.substring(start, lineEnd), format, font, metrics, measuredWidth[0]));
                    start += count;
                    continue;
                }
                if (!Character.isWhitespace(ltext.charAt(lineEnd - 1)) && !Character.isWhitespace(ltext.charAt(lineEnd))) {
                    while (--lineEnd > start && !Character.isWhitespace(ltext.charAt(lineEnd))) {
                    }
                }
                if (lineEnd == start) {
                    layouts.add(new AndroidTextLayout(ltext.substring(start, start + count), format, font, metrics, measuredWidth[0]));
                    start += count;
                } else {
                    while (Character.isWhitespace(ltext.charAt(lineEnd - 1))) {
                        --lineEnd;
                    }
                    String line = ltext.substring(start, lineEnd);
                    float size = paint.measureText(line);
                    layouts.add(new AndroidTextLayout(line, format, font, metrics, size));
                    start = lineEnd;
                }
                while (start < end && Character.isWhitespace(ltext.charAt(start))) {
                    ++start;
                }
            }
        }
        return layouts.toArray(new TextLayout[layouts.size()]);
    }

    public float ascent() {
        return -this.metrics.ascent;
    }

    public float descent() {
        return this.metrics.descent;
    }

    public float leading() {
        return this.metrics.leading;
    }

    AndroidTextLayout(String text, TextFormat format, AndroidFont font, Paint.FontMetrics metrics, float width) {
        this(text, format, font, metrics, width, -metrics.ascent + metrics.descent);
    }

    AndroidTextLayout(String text, TextFormat format, AndroidFont font, Paint.FontMetrics metrics, float width, float height) {
        super(text, format, (IRectangle)new Rectangle(0.0f, 0.0f, width, height), height);
        this.font = font;
        this.metrics = metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void draw(Canvas canvas, float x, float y, Paint paint) {
        boolean oldAA = paint.isAntiAlias();
        paint.setAntiAlias(this.format.antialias);
        try {
            paint.setTypeface(this.font.typeface);
            paint.setTextSize(this.font.size);
            paint.setSubpixelText(true);
            if (this.font.size > 250.0f) {
                Path path = new Path();
                paint.getTextPath(this.text, 0, this.text.length(), x, y - this.metrics.ascent, path);
                canvas.drawPath(path, paint);
            } else {
                canvas.drawText(this.text, x, y - this.metrics.ascent, paint);
            }
        }
        finally {
            paint.setAntiAlias(oldAA);
        }
    }

    static int accountForLigatures(String text, int start, int count, String[] ligatures) {
        int adjust = 0;
        for (String lig : ligatures) {
            int llen = lig.length();
            int idx = start;
            while ((idx = text.indexOf(lig, idx)) != -1 && idx + 1 <= start + count) {
                int extra = llen - 1;
                adjust += extra;
                count += extra;
                idx += llen;
            }
        }
        return adjust;
    }
}

