/*
 * Decompiled with CFR 0.152.
 */
package playn.android;

import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.util.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import playn.android.AndroidCanvas;
import playn.android.AndroidCanvasState;
import playn.android.AndroidFont;
import playn.android.AndroidGL20;
import playn.android.AndroidGradient;
import playn.android.AndroidImage;
import playn.android.AndroidPath;
import playn.android.AndroidTextLayout;
import playn.core.Canvas;
import playn.core.Font;
import playn.core.GL20;
import playn.core.Gradient;
import playn.core.Graphics;
import playn.core.Path;
import playn.core.Platform;
import playn.core.Scale;
import playn.core.TextFormat;
import playn.core.TextLayout;
import playn.core.TextWrap;
import pythagoras.f.Dimension;
import pythagoras.f.IDimension;
import pythagoras.f.IPoint;
import pythagoras.f.Point;

public class AndroidGraphics
extends Graphics {
    private final Point touchTemp = new Point();
    private Map<Refreshable, Void> refreshables = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Pair<String, Font.Style>, Typeface> fonts = new HashMap<Pair<String, Font.Style>, Typeface>();
    private final Map<Pair<String, Font.Style>, String[]> ligatureHacks = new HashMap<Pair<String, Font.Style>, String[]>();
    private Dimension screenSize = new Dimension();
    private ScaleFunc canvasScaleFunc = new ScaleFunc(){

        @Override
        public Scale computeScale(float width, float height, Scale gfxScale) {
            return gfxScale;
        }
    };
    final Bitmap.Config preferredBitmapConfig;

    public AndroidGraphics(Platform plat, Bitmap.Config bitmapConfig, float scaleFactor) {
        super(plat, (GL20)new AndroidGL20(), new Scale(scaleFactor));
        this.preferredBitmapConfig = bitmapConfig;
    }

    public void registerFont(Typeface face, String name, Font.Style style, String ... ligatureGlyphs) {
        Pair key = Pair.create((Object)name, (Object)style);
        this.fonts.put((Pair<String, Font.Style>)key, face);
        this.ligatureHacks.put((Pair<String, Font.Style>)key, ligatureGlyphs);
    }

    public void setCanvasFilterBitmaps(boolean filterBitmaps) {
        AndroidCanvasState.PAINT_FLAGS = filterBitmaps ? (AndroidCanvasState.PAINT_FLAGS |= 2) : (AndroidCanvasState.PAINT_FLAGS &= 0xFFFFFFFD);
    }

    public void setCanvasScaleFunc(ScaleFunc scaleFunc) {
        if (scaleFunc == null) {
            throw new NullPointerException("Scale func must not be null");
        }
        this.canvasScaleFunc = scaleFunc;
    }

    public void onSurfaceCreated() {
        for (Refreshable ref : this.refreshables.keySet()) {
            ref.onSurfaceCreated();
        }
    }

    public void onSurfaceChanged(int pixelWidth, int pixelHeight, int orient) {
        this.viewportChanged(pixelWidth, pixelHeight);
        this.screenSize.setSize(this.viewSize);
        switch (orient) {
            case 2: {
                this.orientDetailM.update((Object)Graphics.OrientationDetail.LANDSCAPE_LEFT);
                break;
            }
            case 1: {
                this.orientDetailM.update((Object)Graphics.OrientationDetail.PORTRAIT);
                break;
            }
            default: {
                this.orientDetailM.update((Object)Graphics.OrientationDetail.UNKNOWN);
            }
        }
    }

    public void onSurfaceLost() {
        for (Refreshable ref : this.refreshables.keySet()) {
            ref.onSurfaceLost();
        }
    }

    public IDimension screenSize() {
        return this.screenSize;
    }

    public Canvas createCanvas(float width, float height) {
        Scale scale = this.canvasScaleFunc.computeScale(width, height, this.scale());
        return this.createCanvas(scale, scale.scaledCeil(width), scale.scaledCeil(height));
    }

    public Canvas createCanvas(Scale scale, int pixelWidth, int pixelHeight) {
        Bitmap bitmap = Bitmap.createBitmap((int)pixelWidth, (int)pixelHeight, (Bitmap.Config)this.preferredBitmapConfig);
        return new AndroidCanvas(this, new AndroidImage(this, scale, bitmap, "<canvas>"));
    }

    public Path createPath() {
        return new AndroidPath();
    }

    public Gradient createGradient(Gradient.Config cfg) {
        return new AndroidGradient(cfg);
    }

    public TextLayout layoutText(String text, TextFormat format) {
        return AndroidTextLayout.layoutText(this, text, format);
    }

    public TextLayout[] layoutText(String text, TextFormat format, TextWrap wrap) {
        return AndroidTextLayout.layoutText(this, text, format, wrap);
    }

    AndroidFont resolveFont(Font font) {
        if (font == null) {
            return AndroidFont.DEFAULT;
        }
        Pair key = Pair.create((Object)font.name, (Object)font.style);
        Typeface face = this.fonts.get(key);
        if (face == null) {
            face = AndroidFont.create(font);
            this.fonts.put((Pair<String, Font.Style>)key, face);
        }
        return new AndroidFont(face, font.size, this.ligatureHacks.get(key));
    }

    void addRefreshable(Refreshable ref) {
        assert (ref != null);
        this.refreshables.put(ref, null);
    }

    void removeRefreshable(Refreshable ref) {
        assert (ref != null);
        this.refreshables.remove(ref);
    }

    IPoint transformTouch(float x, float y) {
        float factor = this.scale().factor;
        return this.touchTemp.set(x / factor, y / factor);
    }

    public static interface ScaleFunc {
        public Scale computeScale(float var1, float var2, Scale var3);
    }

    public static interface Refreshable {
        public void onSurfaceLost();

        public void onSurfaceCreated();
    }
}

