/*
 * Decompiled with CFR 0.152.
 */
package playn.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import playn.android.AndroidPlatform;
import playn.android.GameViewGL;

public abstract class GameActivity
extends Activity {
    private final int REQUIRED_CONFIG_CHANGES = 1184;
    private AndroidPlatform platform;
    private GameViewGL gameView;

    public abstract void main();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Context appctx = this.getApplicationContext();
        this.platform = this.createPlatform();
        this.gameView = new GameViewGL(appctx, this.platform);
        int windowFlags = this.makeWindowFlags();
        this.getWindow().setFlags(windowFlags, windowFlags);
        this.setContentView(this.gameView);
        try {
            ActivityInfo info = this.getPackageManager().getActivityInfo(new ComponentName(appctx, ((Object)((Object)this)).getClass()), 0);
            if ((info.configChanges & 0x4A0) != 1184) {
                new AlertDialog.Builder((Context)this).setMessage((CharSequence)"Unable to guarantee application will handle configuration changes. Please add the following line to the Activity manifest:       android:configChanges=\"keyboardHidden|orientation|screenSize\"").show();
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            this.platform.log().warn("Cannot access game AndroidManifest.xml file.");
        }
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        AndroidPlatform.debugLog("onWindowFocusChanged(" + hasFocus + ")");
        this.platform.input().focus.emit((Object)hasFocus);
        if (hasFocus) {
            this.platform.audio().onResume();
        } else {
            this.platform.audio().onPause();
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        this.platform.input().onKeyDown(keyCode, event);
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        this.platform.input().onKeyUp(keyCode, event);
        return super.onKeyUp(keyCode, event);
    }

    public void onBackPressed() {
        this.moveTaskToBack(false);
    }

    protected void onDestroy() {
        AndroidPlatform.debugLog("onDestroy");
        this.platform.audio().onDestroy();
        this.platform.onExit();
        super.onDestroy();
    }

    protected void onPause() {
        AndroidPlatform.debugLog("onPause");
        this.gameView.onPause();
        this.platform.onPause();
        super.onPause();
    }

    protected void onResume() {
        AndroidPlatform.debugLog("onResume");
        this.platform.onResume();
        this.gameView.onResume();
        super.onResume();
    }

    protected int makeWindowFlags() {
        return 0x1000400;
    }

    protected String prefsName() {
        return "playn";
    }

    protected String logIdent() {
        return "playn";
    }

    protected Bitmap.Config preferredBitmapConfig() {
        return Bitmap.Config.ARGB_8888;
    }

    protected float scaleFactor() {
        return this.getResources().getDisplayMetrics().density;
    }

    protected int maxSimultaneousSounds() {
        return 8;
    }

    public GameViewGL gameView() {
        return this.gameView;
    }

    protected AndroidPlatform createPlatform() {
        return new AndroidPlatform(this);
    }

    protected AndroidPlatform platform() {
        return this.platform;
    }

    protected void setContentView(GameViewGL view) {
        LinearLayout layout = new LinearLayout((Context)this);
        layout.setBackgroundColor(-16777216);
        layout.setGravity(17);
        layout.addView((View)this.gameView);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        this.getWindow().setContentView((View)layout, params);
    }
}

