/*
 * Decompiled with CFR 0.152.
 */
package playn.android;

import android.opengl.GLES20;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import playn.core.GL20;

public class AndroidGL20
extends GL20 {
    public AndroidGL20() {
        super(new GL20.Buffers(){

            public ByteBuffer createByteBuffer(int size) {
                return ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
            }
        }, false);
    }

    public String getPlatformGLExtensions() {
        String extensions = GLES20.glGetString((int)7939);
        return extensions;
    }

    public int getSwapInterval() {
        return 0;
    }

    public void glActiveTexture(int texture) {
        GLES20.glActiveTexture((int)texture);
    }

    public void glAttachShader(int program, int shader) {
        GLES20.glAttachShader((int)program, (int)shader);
    }

    public void glBindAttribLocation(int program, int index, String name) {
        GLES20.glBindAttribLocation((int)program, (int)index, (String)name);
    }

    public void glBindBuffer(int target, int buffer) {
        GLES20.glBindBuffer((int)target, (int)buffer);
    }

    public void glBindFramebuffer(int target, int framebuffer) {
        GLES20.glBindFramebuffer((int)target, (int)framebuffer);
    }

    public void glBindRenderbuffer(int target, int renderbuffer) {
        GLES20.glBindRenderbuffer((int)target, (int)renderbuffer);
    }

    public void glBindTexture(int target, int texture) {
        GLES20.glBindTexture((int)target, (int)texture);
    }

    public void glBlendColor(float red, float green, float blue, float alpha) {
        GLES20.glBlendColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void glBlendEquation(int mode) throws RuntimeException {
        GLES20.glBlendEquation((int)mode);
    }

    public void glBlendEquationSeparate(int modeRGB, int modeAlpha) throws RuntimeException {
        GLES20.glBlendEquationSeparate((int)modeRGB, (int)modeAlpha);
    }

    public void glBlendFunc(int sfactor, int dfactor) {
        GLES20.glBlendFunc((int)sfactor, (int)dfactor);
    }

    public void glBlendFuncSeparate(int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) throws RuntimeException {
        GLES20.glBlendFuncSeparate((int)srcRGB, (int)dstRGB, (int)srcAlpha, (int)dstAlpha);
    }

    public void glBufferData(int target, int size, Buffer data, int usage) {
        GLES20.glBufferData((int)target, (int)size, (Buffer)data, (int)usage);
    }

    public void glBufferSubData(int target, int offset, int size, Buffer data) {
        GLES20.glBufferSubData((int)target, (int)offset, (int)size, (Buffer)data);
    }

    public int glCheckFramebufferStatus(int target) {
        return GLES20.glCheckFramebufferStatus((int)target);
    }

    public void glClear(int mask) {
        GLES20.glClear((int)mask);
    }

    public void glClearColor(float red, float green, float blue, float alpha) {
        GLES20.glClearColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void glClearDepth(double depth) {
        GLES20.glClearDepthf((float)((float)depth));
    }

    public void glClearDepthf(float depth) {
        GLES20.glClearDepthf((float)depth);
    }

    public void glClearStencil(int s) {
        GLES20.glClearStencil((int)s);
    }

    public void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        GLES20.glColorMask((boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
    }

    public void glCompileShader(int shader) {
        GLES20.glCompileShader((int)shader);
    }

    public void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, Buffer data) {
        GLES20.glCompressedTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)imageSize, (Buffer)data);
    }

    public void glCompressedTexImage2D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7) throws RuntimeException {
        throw new RuntimeException("glCompressedTexImage2D(int, int, int, int, int, int, int, int)not supported.");
    }

    public void glCompressedTexImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, Buffer arg8) {
        throw new RuntimeException("glCompressedTexImage3D not supported.");
    }

    public void glCompressedTexImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8) throws RuntimeException {
        throw new RuntimeException("glCompressedTexImage3D not supported.");
    }

    public void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, Buffer data) {
        GLES20.glCompressedTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)imageSize, (Buffer)data);
    }

    public void glCompressedTexSubImage2D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8) throws RuntimeException {
        throw new RuntimeException("glCompressedSubTexImage2D(int, int, int, int, int, int, int, int, int)not supported.");
    }

    public void glCompressedTexSubImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, Buffer arg10) throws RuntimeException {
        throw new RuntimeException("glCompressedTexSubImage3D not supported.");
    }

    public void glCompressedTexSubImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10) throws RuntimeException {
        throw new RuntimeException("glCompressedTexSubImage3D not supported.");
    }

    public void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border) {
        GLES20.glCopyTexImage2D((int)target, (int)level, (int)internalformat, (int)x, (int)y, (int)width, (int)height, (int)border);
    }

    public void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        GLES20.glCopyTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)x, (int)y, (int)width, (int)height);
    }

    public void glCopyTexSubImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8) throws RuntimeException {
        throw new RuntimeException("glCopyTexSubImage3D not supported.");
    }

    public int glCreateProgram() {
        return GLES20.glCreateProgram();
    }

    public int glCreateShader(int type) {
        return GLES20.glCreateShader((int)type);
    }

    public void glCullFace(int mode) {
        GLES20.glCullFace((int)mode);
    }

    public void glDeleteBuffers(int n, int[] buffers, int offset) {
        GLES20.glDeleteBuffers((int)n, (int[])buffers, (int)offset);
    }

    public void glDeleteBuffers(int n, IntBuffer buffers) {
        GLES20.glDeleteBuffers((int)n, (IntBuffer)buffers);
    }

    public void glDeleteFramebuffers(int n, int[] framebuffers, int offset) {
        GLES20.glDeleteFramebuffers((int)n, (int[])framebuffers, (int)offset);
    }

    public void glDeleteFramebuffers(int n, IntBuffer framebuffers) {
        GLES20.glDeleteFramebuffers((int)n, (IntBuffer)framebuffers);
    }

    public void glDeleteProgram(int program) {
        GLES20.glDeleteProgram((int)program);
    }

    public void glDeleteRenderbuffers(int n, int[] renderbuffers, int offset) {
        GLES20.glDeleteRenderbuffers((int)n, (int[])renderbuffers, (int)offset);
    }

    public void glDeleteRenderbuffers(int n, IntBuffer renderbuffers) {
        GLES20.glDeleteRenderbuffers((int)n, (IntBuffer)renderbuffers);
    }

    public void glDeleteShader(int shader) {
        GLES20.glDeleteShader((int)shader);
    }

    public void glDeleteTextures(int n, int[] textures, int offset) {
        GLES20.glDeleteTextures((int)n, (int[])textures, (int)offset);
    }

    public void glDeleteTextures(int n, IntBuffer textures) {
        GLES20.glDeleteTextures((int)n, (IntBuffer)textures);
    }

    public void glDepthFunc(int func) {
        GLES20.glDepthFunc((int)func);
    }

    public void glDepthMask(boolean flag) {
        GLES20.glDepthMask((boolean)flag);
    }

    public void glDepthRange(double zNear, double zFar) {
        GLES20.glDepthRangef((float)((float)zNear), (float)((float)zFar));
    }

    public void glDepthRangef(float zNear, float zFar) {
        GLES20.glDepthRangef((float)zNear, (float)zFar);
    }

    public void glDetachShader(int program, int shader) {
        GLES20.glDetachShader((int)program, (int)shader);
    }

    public void glDisable(int cap) {
        GLES20.glDisable((int)cap);
    }

    public void glDisableVertexAttribArray(int index) {
        GLES20.glDisableVertexAttribArray((int)index);
    }

    public void glDrawArrays(int mode, int first, int count) {
        GLES20.glDrawArrays((int)mode, (int)first, (int)count);
    }

    public void glDrawElements(int mode, int count, int type, Buffer indices) {
        GLES20.glDrawElements((int)mode, (int)count, (int)type, (Buffer)indices);
    }

    public void glDrawElements(int mode, int count, int type, int offset) {
        GLES20.glDrawElements((int)mode, (int)count, (int)type, (int)offset);
    }

    public void glEnable(int cap) {
        GLES20.glEnable((int)cap);
    }

    public void glEnableVertexAttribArray(int index) {
        GLES20.glEnableVertexAttribArray((int)index);
    }

    public void glFinish() {
        GLES20.glFinish();
    }

    public void glFlush() {
        GLES20.glFlush();
    }

    public void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        GLES20.glFramebufferRenderbuffer((int)target, (int)attachment, (int)renderbuffertarget, (int)renderbuffer);
    }

    public void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        GLES20.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
    }

    public void glFramebufferTexture3D(int target, int attachment, int textarget, int texture, int level, int zoffset) {
        GLES20.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
    }

    public void glFrontFace(int mode) {
        GLES20.glFrontFace((int)mode);
    }

    public void glGenBuffers(int n, int[] buffers, int offset) {
        GLES20.glGenBuffers((int)n, (int[])buffers, (int)offset);
    }

    public void glGenBuffers(int n, IntBuffer buffers) {
        GLES20.glGenBuffers((int)n, (IntBuffer)buffers);
    }

    public void glGenerateMipmap(int target) {
        GLES20.glGenerateMipmap((int)target);
    }

    public void glGenFramebuffers(int n, int[] framebuffers, int offset) {
        GLES20.glGenFramebuffers((int)n, (int[])framebuffers, (int)offset);
    }

    public void glGenFramebuffers(int n, IntBuffer framebuffers) {
        GLES20.glGenFramebuffers((int)n, (IntBuffer)framebuffers);
    }

    public void glGenRenderbuffers(int n, int[] renderbuffers, int offset) {
        GLES20.glGenRenderbuffers((int)n, (int[])renderbuffers, (int)offset);
    }

    public void glGenRenderbuffers(int n, IntBuffer renderbuffers) {
        GLES20.glGenRenderbuffers((int)n, (IntBuffer)renderbuffers);
    }

    public void glGenTextures(int n, int[] textures, int offset) {
        GLES20.glGenTextures((int)n, (int[])textures, (int)offset);
    }

    public void glGenTextures(int n, IntBuffer textures) {
        GLES20.glGenTextures((int)n, (IntBuffer)textures);
    }

    public String glGetActiveAttrib(int program, int index, IntBuffer size, IntBuffer type) {
        throw new RuntimeException("Not implemented");
    }

    public String glGetActiveUniform(int program, int index, IntBuffer size, IntBuffer type) {
        throw new RuntimeException("Not implemented");
    }

    public void glGetAttachedShaders(int program, int maxcount, int[] count, int countOffset, int[] shaders, int shadersOffset) {
        GLES20.glGetAttachedShaders((int)program, (int)maxcount, (int[])count, (int)countOffset, (int[])shaders, (int)shadersOffset);
    }

    public void glGetAttachedShaders(int program, int maxcount, IntBuffer count, IntBuffer shaders) {
        GLES20.glGetAttachedShaders((int)program, (int)maxcount, (IntBuffer)count, (IntBuffer)shaders);
    }

    public int glGetAttribLocation(int program, String name) {
        return GLES20.glGetAttribLocation((int)program, (String)name);
    }

    public boolean glGetBoolean(int pname) {
        byte[] out = new byte[1];
        this.glGetBooleanv(pname, out, 0);
        return out[0] != 0;
    }

    public void glGetBooleanv(int pname, byte[] params, int offset) {
        ByteBuffer buffer = ByteBuffer.wrap(params, offset, params.length - offset);
        GLES20.glGetBooleanv((int)pname, (IntBuffer)buffer.asIntBuffer());
    }

    public void glGetBooleanv(int pname, ByteBuffer params) {
        GLES20.glGetBooleanv((int)pname, (IntBuffer)params.asIntBuffer());
    }

    public int glGetBoundBuffer(int arg0) throws RuntimeException {
        throw new RuntimeException("glGetBoundBuffer not supported in GLES 2.0");
    }

    public void glGetBufferParameteriv(int target, int pname, int[] params, int offset) {
        GLES20.glGetBufferParameteriv((int)target, (int)pname, (int[])params, (int)offset);
    }

    public void glGetBufferParameteriv(int target, int pname, IntBuffer params) {
        GLES20.glGetBufferParameteriv((int)target, (int)pname, (IntBuffer)params);
    }

    public int glGetError() {
        return GLES20.glGetError();
    }

    public float glGetFloat(int pname) {
        float[] out = new float[1];
        GLES20.glGetFloatv((int)pname, (float[])out, (int)0);
        return out[0];
    }

    public void glGetFloatv(int pname, float[] params, int offset) {
        GLES20.glGetFloatv((int)pname, (float[])params, (int)offset);
    }

    public void glGetFloatv(int pname, FloatBuffer params) {
        GLES20.glGetFloatv((int)pname, (FloatBuffer)params);
    }

    public void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, int[] params, int offset) {
        GLES20.glGetFramebufferAttachmentParameteriv((int)target, (int)attachment, (int)pname, (int[])params, (int)offset);
    }

    public void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, IntBuffer params) {
        GLES20.glGetFramebufferAttachmentParameteriv((int)target, (int)attachment, (int)pname, (IntBuffer)params);
    }

    public int glGetInteger(int pname) {
        int[] out = new int[1];
        GLES20.glGetIntegerv((int)pname, (int[])out, (int)0);
        return out[0];
    }

    public void glGetIntegerv(int pname, int[] params, int offset) {
        GLES20.glGetIntegerv((int)pname, (int[])params, (int)offset);
    }

    public void glGetIntegerv(int pname, IntBuffer params) {
        GLES20.glGetIntegerv((int)pname, (IntBuffer)params);
    }

    public void glGetProgramBinary(int arg0, int arg1, int[] arg2, int arg3, int[] arg4, int arg5, Buffer arg6) throws RuntimeException {
        throw new RuntimeException("glGetProgramBinary not supported.");
    }

    public void glGetProgramBinary(int arg0, int arg1, IntBuffer arg2, IntBuffer arg3, Buffer arg4) throws RuntimeException {
        throw new RuntimeException("glGetProgramBinary not supported.");
    }

    public void glGetProgramInfoLog(int program, int bufsize, int[] length, int lengthOffset, byte[] infolog, int infologOffset) {
        String log = GLES20.glGetProgramInfoLog((int)program);
        byte[] byteArray = log.getBytes();
        for (int i = 0; i < bufsize && i < byteArray.length; ++i) {
            infolog[i + infologOffset] = byteArray[i];
        }
        length[lengthOffset] = log.length();
    }

    public void glGetProgramInfoLog(int program, int bufsize, IntBuffer length, ByteBuffer infolog) {
        this.glGetProgramInfoLog(program, bufsize, length.array(), infolog.position(), infolog.array(), infolog.position());
    }

    public String glGetProgramInfoLog(int program) {
        return GLES20.glGetProgramInfoLog((int)program);
    }

    public void glGetProgramiv(int program, int pname, int[] params, int offset) {
        GLES20.glGetProgramiv((int)program, (int)pname, (int[])params, (int)offset);
    }

    public void glGetProgramiv(int program, int pname, IntBuffer params) {
        GLES20.glGetProgramiv((int)program, (int)pname, (IntBuffer)params);
    }

    public void glGetRenderbufferParameteriv(int target, int pname, int[] params, int offset) {
        GLES20.glGetRenderbufferParameteriv((int)target, (int)pname, (int[])params, (int)offset);
    }

    public void glGetRenderbufferParameteriv(int target, int pname, IntBuffer params) {
        GLES20.glGetRenderbufferParameteriv((int)target, (int)pname, (IntBuffer)params);
    }

    public void glGetShaderInfoLog(int shader, int bufsize, int[] length, int lengthOffset, byte[] infolog, int infologOffset) {
        String log = GLES20.glGetShaderInfoLog((int)shader);
        byte[] byteArray = log.getBytes();
        for (int i = 0; i < bufsize && i < byteArray.length; ++i) {
            infolog[i + infologOffset] = byteArray[i];
        }
        length[lengthOffset] = log.length();
    }

    public void glGetShaderInfoLog(int shader, int bufsize, IntBuffer length, ByteBuffer infolog) {
        this.glGetShaderInfoLog(shader, bufsize, length.array(), length.position(), infolog.array(), infolog.position());
    }

    public String glGetShaderInfoLog(int shader) {
        return GLES20.glGetShaderInfoLog((int)shader);
    }

    public void glGetShaderiv(int shader, int pname, int[] params, int offset) {
        GLES20.glGetShaderiv((int)shader, (int)pname, (int[])params, (int)offset);
    }

    public void glGetShaderiv(int shader, int pname, IntBuffer params) {
        GLES20.glGetShaderiv((int)shader, (int)pname, (IntBuffer)params);
    }

    public void glGetShaderPrecisionFormat(int shadertype, int precisiontype, int[] range, int rangeOffset, int[] precision, int precisionOffset) {
        GLES20.glGetShaderPrecisionFormat((int)shadertype, (int)precisiontype, (int[])range, (int)rangeOffset, (int[])precision, (int)precisionOffset);
    }

    public void glGetShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range, IntBuffer precision) {
        GLES20.glGetShaderPrecisionFormat((int)shadertype, (int)precisiontype, (IntBuffer)range, (IntBuffer)precision);
    }

    public void glGetShaderSource(int shader, int bufsize, int[] length, int lengthOffset, byte[] source, int sourceOffset) {
        GLES20.glGetShaderSource((int)shader, (int)bufsize, (int[])length, (int)lengthOffset, (byte[])source, (int)sourceOffset);
    }

    public void glGetShaderSource(int shader, int bufsize, IntBuffer length, ByteBuffer source) {
        GLES20.glGetShaderSource((int)shader, (int)bufsize, (int[])length.array(), (int)0, (byte[])source.array(), (int)0);
    }

    public String glGetString(int name) {
        return GLES20.glGetString((int)name);
    }

    public void glGetTexParameterfv(int target, int pname, float[] params, int offset) {
        GLES20.glGetTexParameterfv((int)target, (int)pname, (float[])params, (int)offset);
    }

    public void glGetTexParameterfv(int target, int pname, FloatBuffer params) {
        GLES20.glGetTexParameterfv((int)target, (int)pname, (FloatBuffer)params);
    }

    public void glGetTexParameteriv(int target, int pname, int[] params, int offset) {
        GLES20.glGetTexParameteriv((int)target, (int)pname, (int[])params, (int)offset);
    }

    public void glGetTexParameteriv(int target, int pname, IntBuffer params) {
        GLES20.glGetTexParameteriv((int)target, (int)pname, (IntBuffer)params);
    }

    public void glGetUniformfv(int program, int location, float[] params, int offset) {
        GLES20.glGetUniformfv((int)program, (int)location, (float[])params, (int)offset);
    }

    public void glGetUniformfv(int program, int location, FloatBuffer params) {
        GLES20.glGetUniformfv((int)program, (int)location, (FloatBuffer)params);
    }

    public void glGetUniformiv(int program, int location, int[] params, int offset) {
        GLES20.glGetUniformiv((int)program, (int)location, (int[])params, (int)offset);
    }

    public void glGetUniformiv(int program, int location, IntBuffer params) {
        GLES20.glGetUniformiv((int)program, (int)location, (IntBuffer)params);
    }

    public int glGetUniformLocation(int program, String name) {
        return GLES20.glGetUniformLocation((int)program, (String)name);
    }

    public void glGetVertexAttribfv(int index, int pname, float[] params, int offset) {
        GLES20.glGetVertexAttribfv((int)index, (int)pname, (float[])params, (int)offset);
    }

    public void glGetVertexAttribfv(int index, int pname, FloatBuffer params) {
        GLES20.glGetVertexAttribfv((int)index, (int)pname, (FloatBuffer)params);
    }

    public void glGetVertexAttribiv(int index, int pname, int[] params, int offset) {
        GLES20.glGetVertexAttribiv((int)index, (int)pname, (int[])params, (int)offset);
    }

    public void glGetVertexAttribiv(int index, int pname, IntBuffer params) {
        GLES20.glGetVertexAttribiv((int)index, (int)pname, (IntBuffer)params);
    }

    public void glHint(int target, int mode) {
        GLES20.glHint((int)target, (int)mode);
    }

    public boolean glIsBuffer(int buffer) {
        return GLES20.glIsBuffer((int)buffer);
    }

    public boolean glIsEnabled(int cap) {
        return GLES20.glIsEnabled((int)cap);
    }

    public boolean glIsFramebuffer(int framebuffer) {
        return GLES20.glIsFramebuffer((int)framebuffer);
    }

    public boolean glIsProgram(int program) {
        return GLES20.glIsProgram((int)program);
    }

    public boolean glIsRenderbuffer(int renderbuffer) {
        return GLES20.glIsRenderbuffer((int)renderbuffer);
    }

    public boolean glIsShader(int shader) {
        return GLES20.glIsShader((int)shader);
    }

    public boolean glIsTexture(int texture) {
        return GLES20.glIsTexture((int)texture);
    }

    public boolean glIsVBOArrayEnabled() {
        return this.isExtensionAvailable("vertex_buffer_object");
    }

    public boolean glIsVBOElementEnabled() {
        return this.glIsVBOArrayEnabled();
    }

    public void glLineWidth(float width) {
        GLES20.glLineWidth((float)width);
    }

    public void glLinkProgram(int program) {
        GLES20.glLinkProgram((int)program);
    }

    public ByteBuffer glMapBuffer(int arg0, int arg1) throws RuntimeException {
        throw new RuntimeException("glMapBuffer() not supported.");
    }

    public void glPixelStorei(int pname, int param) {
        GLES20.glPixelStorei((int)pname, (int)param);
    }

    public void glPolygonOffset(float factor, float units) {
        GLES20.glPolygonOffset((float)factor, (float)units);
    }

    public void glProgramBinary(int arg0, int arg1, Buffer arg2, int arg3) throws RuntimeException {
        throw new RuntimeException("glProgramBinary() not supported.");
    }

    public void glReadPixels(int x, int y, int width, int height, int format, int type, Buffer pixels) {
        GLES20.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (Buffer)pixels);
    }

    public void glReadPixels(int x, int y, int width, int height, int format, int type, int pixelsBufferOffset) throws RuntimeException {
        throw new RuntimeException("Not supported.  Please call glReadPixels(int, int, int, int, int, int, Buffer) instead");
    }

    public void glReleaseShaderCompiler() {
        GLES20.glReleaseShaderCompiler();
    }

    public void glRenderbufferStorage(int target, int internalformat, int width, int height) {
        GLES20.glRenderbufferStorage((int)target, (int)internalformat, (int)width, (int)height);
    }

    public void glSampleCoverage(float value, boolean invert) {
        GLES20.glSampleCoverage((float)value, (boolean)invert);
    }

    public void glScissor(int x, int y, int width, int height) {
        GLES20.glScissor((int)x, (int)y, (int)width, (int)height);
    }

    public void glShaderBinary(int n, int[] shaders, int offset, int binaryformat, Buffer binary, int length) {
        GLES20.glShaderBinary((int)n, (int[])shaders, (int)offset, (int)binaryformat, (Buffer)binary, (int)length);
    }

    public void glShaderBinary(int n, IntBuffer shaders, int binaryformat, Buffer binary, int length) {
        GLES20.glShaderBinary((int)n, (IntBuffer)shaders, (int)binaryformat, (Buffer)binary, (int)length);
    }

    public void glShaderSource(int shader, int count, String[] strings, int[] length, int lengthOffset) {
        int totalLength = 0;
        for (int i = lengthOffset; i < length.length; ++i) {
            totalLength += length[i];
        }
        StringBuilder builder = new StringBuilder(totalLength);
        for (int j = 0; j < count; ++j) {
            builder.append(strings[j], 0, length[j]);
        }
        GLES20.glShaderSource((int)shader, (String)builder.toString());
    }

    public void glShaderSource(int shader, int count, String[] strings, IntBuffer length) {
        this.glShaderSource(shader, count, strings, length.array(), 0);
    }

    public void glShaderSource(int shader, String string) {
        GLES20.glShaderSource((int)shader, (String)string);
    }

    public void glStencilFunc(int func, int ref, int mask) {
        GLES20.glStencilFunc((int)func, (int)ref, (int)mask);
    }

    public void glStencilFuncSeparate(int face, int func, int ref, int mask) {
        GLES20.glStencilFuncSeparate((int)face, (int)func, (int)ref, (int)mask);
    }

    public void glStencilMask(int mask) {
        GLES20.glStencilMask((int)mask);
    }

    public void glStencilMaskSeparate(int face, int mask) {
        GLES20.glStencilMaskSeparate((int)face, (int)mask);
    }

    public void glStencilOp(int fail, int zfail, int zpass) {
        GLES20.glStencilOp((int)fail, (int)zfail, (int)zpass);
    }

    public void glStencilOpSeparate(int face, int fail, int zfail, int zpass) {
        GLES20.glStencilOpSeparate((int)face, (int)fail, (int)zfail, (int)zpass);
    }

    public void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, Buffer pixels) {
        GLES20.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (Buffer)pixels);
    }

    public void glTexImage2D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8) {
    }

    public void glTexImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, Buffer arg9) throws RuntimeException {
        throw new RuntimeException("glTexImage3D not supported!");
    }

    public void glTexImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9) throws RuntimeException {
        throw new RuntimeException("glTexImage3D not supported!");
    }

    public void glTexParameterf(int target, int pname, float param) {
        GLES20.glTexParameterf((int)target, (int)pname, (float)param);
    }

    public void glTexParameterfv(int target, int pname, float[] params, int offset) {
        GLES20.glTexParameterfv((int)target, (int)pname, (float[])params, (int)offset);
    }

    public void glTexParameterfv(int target, int pname, FloatBuffer params) {
        GLES20.glTexParameterfv((int)target, (int)pname, (FloatBuffer)params);
    }

    public void glTexParameteri(int target, int pname, int param) {
        GLES20.glTexParameteri((int)target, (int)pname, (int)param);
    }

    public void glTexParameteriv(int target, int pname, int[] params, int offset) {
        GLES20.glTexParameteriv((int)target, (int)pname, (int[])params, (int)offset);
    }

    public void glTexParameteriv(int target, int pname, IntBuffer params) {
        GLES20.glTexParameteriv((int)target, (int)pname, (IntBuffer)params);
    }

    public void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, Buffer pixels) {
        GLES20.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (Buffer)pixels);
    }

    public void glTexSubImage2D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8) throws RuntimeException {
        throw new RuntimeException("glTexSubImage2D(int, int, int, int, int, int, int, int, int) not supported.");
    }

    public void glTexSubImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, Buffer arg10) throws RuntimeException {
        throw new RuntimeException("glTexSubImage3D not supported!");
    }

    public void glTexSubImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10) throws RuntimeException {
        throw new RuntimeException("glTexSubImage3D not supported!");
    }

    public void glUniform1f(int location, float x) {
        GLES20.glUniform1f((int)location, (float)x);
    }

    public void glUniform1fv(int location, int count, float[] v, int offset) {
        GLES20.glUniform1fv((int)location, (int)count, (float[])v, (int)offset);
    }

    public void glUniform1fv(int location, int count, FloatBuffer v) {
        GLES20.glUniform1fv((int)location, (int)count, (FloatBuffer)v);
    }

    public void glUniform1i(int location, int x) {
        GLES20.glUniform1i((int)location, (int)x);
    }

    public void glUniform1iv(int location, int count, int[] v, int offset) {
        GLES20.glUniform1iv((int)location, (int)count, (int[])v, (int)offset);
    }

    public void glUniform1iv(int location, int count, IntBuffer v) {
        GLES20.glUniform1iv((int)location, (int)count, (IntBuffer)v);
    }

    public void glUniform2f(int location, float x, float y) {
        GLES20.glUniform2f((int)location, (float)x, (float)y);
    }

    public void glUniform2fv(int location, int count, float[] v, int offset) {
        GLES20.glUniform2fv((int)location, (int)count, (float[])v, (int)offset);
    }

    public void glUniform2fv(int location, int count, FloatBuffer v) {
        GLES20.glUniform2fv((int)location, (int)count, (FloatBuffer)v);
    }

    public void glUniform2i(int location, int x, int y) {
        GLES20.glUniform2i((int)location, (int)x, (int)y);
    }

    public void glUniform2iv(int location, int count, int[] v, int offset) {
        GLES20.glUniform2iv((int)location, (int)count, (int[])v, (int)offset);
    }

    public void glUniform2iv(int location, int count, IntBuffer v) {
        GLES20.glUniform2iv((int)location, (int)count, (IntBuffer)v);
    }

    public void glUniform3f(int location, float x, float y, float z) {
        GLES20.glUniform3f((int)location, (float)x, (float)y, (float)z);
    }

    public void glUniform3fv(int location, int count, float[] v, int offset) {
        GLES20.glUniform3fv((int)location, (int)count, (float[])v, (int)offset);
    }

    public void glUniform3fv(int location, int count, FloatBuffer v) {
        GLES20.glUniform3fv((int)location, (int)count, (FloatBuffer)v);
    }

    public void glUniform3i(int location, int x, int y, int z) {
        GLES20.glUniform3i((int)location, (int)x, (int)y, (int)z);
    }

    public void glUniform3iv(int location, int count, int[] v, int offset) {
        GLES20.glUniform3iv((int)location, (int)count, (int[])v, (int)offset);
    }

    public void glUniform3iv(int location, int count, IntBuffer v) {
        GLES20.glUniform3iv((int)location, (int)count, (IntBuffer)v);
    }

    public void glUniform4f(int location, float x, float y, float z, float w) {
        GLES20.glUniform4f((int)location, (float)x, (float)y, (float)z, (float)w);
    }

    public void glUniform4fv(int location, int count, float[] v, int offset) {
        GLES20.glUniform4fv((int)location, (int)count, (float[])v, (int)offset);
    }

    public void glUniform4fv(int location, int count, FloatBuffer v) {
        GLES20.glUniform4fv((int)location, (int)count, (FloatBuffer)v);
    }

    public void glUniform4i(int location, int x, int y, int z, int w) {
        GLES20.glUniform4i((int)location, (int)x, (int)y, (int)z, (int)w);
    }

    public void glUniform4iv(int location, int count, int[] v, int offset) {
        GLES20.glUniform4iv((int)location, (int)count, (int[])v, (int)offset);
    }

    public void glUniform4iv(int location, int count, IntBuffer v) {
        GLES20.glUniform4iv((int)location, (int)count, (IntBuffer)v);
    }

    public void glUniformMatrix2fv(int location, int count, boolean transpose, float[] value, int offset) {
        GLES20.glUniformMatrix2fv((int)location, (int)count, (boolean)transpose, (float[])value, (int)offset);
    }

    public void glUniformMatrix2fv(int location, int count, boolean transpose, FloatBuffer value) {
        GLES20.glUniformMatrix2fv((int)location, (int)count, (boolean)transpose, (FloatBuffer)value);
    }

    public void glUniformMatrix3fv(int location, int count, boolean transpose, float[] value, int offset) {
        GLES20.glUniformMatrix3fv((int)location, (int)count, (boolean)transpose, (float[])value, (int)offset);
    }

    public void glUniformMatrix3fv(int location, int count, boolean transpose, FloatBuffer value) {
        GLES20.glUniformMatrix3fv((int)location, (int)count, (boolean)transpose, (FloatBuffer)value);
    }

    public void glUniformMatrix4fv(int location, int count, boolean transpose, float[] value, int offset) {
        GLES20.glUniformMatrix4fv((int)location, (int)count, (boolean)transpose, (float[])value, (int)offset);
    }

    public void glUniformMatrix4fv(int location, int count, boolean transpose, FloatBuffer value) {
        GLES20.glUniformMatrix4fv((int)location, (int)count, (boolean)transpose, (FloatBuffer)value);
    }

    public boolean glUnmapBuffer(int arg0) throws RuntimeException {
        throw new RuntimeException("glUnmapBuffer() not supported.");
    }

    public void glUseProgram(int program) {
        GLES20.glUseProgram((int)program);
    }

    public void glValidateProgram(int program) {
        GLES20.glValidateProgram((int)program);
    }

    public void glVertexAttrib1f(int indx, float x) {
        GLES20.glVertexAttrib1f((int)indx, (float)x);
    }

    public void glVertexAttrib1fv(int indx, float[] values, int offset) {
        GLES20.glVertexAttrib1fv((int)indx, (float[])values, (int)offset);
    }

    public void glVertexAttrib1fv(int indx, FloatBuffer values) {
        GLES20.glVertexAttrib1fv((int)indx, (FloatBuffer)values);
    }

    public void glVertexAttrib2f(int indx, float x, float y) {
        GLES20.glVertexAttrib2f((int)indx, (float)x, (float)y);
    }

    public void glVertexAttrib2fv(int indx, float[] values, int offset) {
        GLES20.glVertexAttrib2fv((int)indx, (float[])values, (int)offset);
    }

    public void glVertexAttrib2fv(int indx, FloatBuffer values) {
        GLES20.glVertexAttrib2fv((int)indx, (FloatBuffer)values);
    }

    public void glVertexAttrib3f(int indx, float x, float y, float z) {
        GLES20.glVertexAttrib3f((int)indx, (float)x, (float)y, (float)z);
    }

    public void glVertexAttrib3fv(int indx, float[] values, int offset) {
        GLES20.glVertexAttrib3fv((int)indx, (float[])values, (int)offset);
    }

    public void glVertexAttrib3fv(int indx, FloatBuffer values) {
        GLES20.glVertexAttrib3fv((int)indx, (FloatBuffer)values);
    }

    public void glVertexAttrib4f(int indx, float x, float y, float z, float w) {
        GLES20.glVertexAttrib4f((int)indx, (float)x, (float)y, (float)z, (float)w);
    }

    public void glVertexAttrib4fv(int indx, float[] values, int offset) {
        GLES20.glVertexAttrib4fv((int)indx, (float[])values, (int)offset);
    }

    public void glVertexAttrib4fv(int indx, FloatBuffer values) {
        GLES20.glVertexAttrib4fv((int)indx, (FloatBuffer)values);
    }

    public void glVertexAttribPointer(int indx, int size, int type, boolean normalized, int stride, Buffer ptr) {
        GLES20.glVertexAttribPointer((int)indx, (int)size, (int)type, (boolean)normalized, (int)stride, (Buffer)ptr);
    }

    public void glVertexAttribPointer(int indx, int size, int type, boolean normalized, int stride, int ptr) {
        GLES20.glVertexAttribPointer((int)indx, (int)size, (int)type, (boolean)normalized, (int)stride, (int)ptr);
    }

    public void glViewport(int x, int y, int width, int height) {
        GLES20.glViewport((int)x, (int)y, (int)width, (int)height);
    }

    public boolean hasGLSL() {
        return true;
    }

    public boolean isExtensionAvailable(String extension) {
        String extensions = GLES20.glGetString((int)7939);
        return extensions.contains(extension);
    }

    public boolean isFunctionAvailable(String function) {
        Method[] functions = ((Object)((Object)this)).getClass().getMethods();
        for (int i = 0; i < functions.length; ++i) {
            if (function != functions[i].getName()) continue;
            return true;
        }
        return false;
    }
}

