/*
 * Decompiled with CFR 0.152.
 */
package playn.android;

import android.graphics.Typeface;
import java.util.EnumMap;
import java.util.Map;
import playn.core.Font;

class AndroidFont {
    private static final String[] NO_HACKS = new String[0];
    public static final AndroidFont DEFAULT = new AndroidFont(Typeface.DEFAULT, 14.0f, null);
    public final Typeface typeface;
    public final float size;
    public final String[] ligatureHacks;
    protected static final Map<Font.Style, Integer> TO_ANDROID_STYLE = new EnumMap<Font.Style, Integer>(Font.Style.class);

    public AndroidFont(Typeface typeface, float size, String[] ligatureHacks) {
        this.typeface = typeface;
        this.size = size;
        this.ligatureHacks = ligatureHacks != null ? ligatureHacks : NO_HACKS;
    }

    public static Typeface create(Font font) {
        return Typeface.create((String)font.name, (int)TO_ANDROID_STYLE.get(font.style));
    }

    static {
        TO_ANDROID_STYLE.put(Font.Style.PLAIN, 0);
        TO_ANDROID_STYLE.put(Font.Style.BOLD, 1);
        TO_ANDROID_STYLE.put(Font.Style.ITALIC, 2);
        TO_ANDROID_STYLE.put(Font.Style.BOLD_ITALIC, 3);
    }
}

