/*
 * Decompiled with CFR 0.152.
 */
package playn.android;

import android.app.Activity;
import android.os.AsyncTask;
import android.os.Looper;
import playn.core.Exec;
import playn.core.Platform;

public class AndroidExec
extends Exec.Default {
    private final Activity activity;

    public AndroidExec(Platform plat, Activity activity) {
        super(plat);
        this.activity = activity;
    }

    protected boolean isPaused() {
        return false;
    }

    public boolean isMainThread() {
        return Thread.currentThread() == Looper.getMainLooper().getThread();
    }

    public void invokeLater(Runnable action) {
        if (this.isPaused()) {
            this.activity.runOnUiThread(action);
        } else {
            super.invokeLater(action);
        }
    }

    public boolean isAsyncSupported() {
        return true;
    }

    public void invokeAsync(final Runnable action) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                new AsyncTask<Void, Void, Void>(){

                    public Void doInBackground(Void ... params) {
                        try {
                            action.run();
                        }
                        catch (Throwable t) {
                            AndroidExec.this.plat.reportError("Async task failure [task=" + action + "]", t);
                        }
                        return null;
                    }
                }.execute((Object[])new Void[0]);
            }
        });
    }
}

