/*
 * Decompiled with CFR 0.152.
 */
package playn.android;

import android.media.MediaPlayer;
import playn.android.AndroidAudio;
import playn.android.AndroidSound;

public class AndroidCompressedSound
extends AndroidSound<MediaPlayer> {
    private final AndroidAudio audio;
    private final AndroidAudio.Resolver<MediaPlayer> resolver;
    private int position;

    public AndroidCompressedSound(AndroidAudio audio, AndroidAudio.Resolver<MediaPlayer> resolver) {
        super(audio.plat.exec());
        this.audio = audio;
        this.resolver = resolver;
        this.resolve();
    }

    public void succeed(MediaPlayer impl) {
        super.succeed((Object)impl);
        impl.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                AndroidCompressedSound.this.audio.onStopped(AndroidCompressedSound.this);
            }
        });
    }

    protected boolean playingImpl() {
        return ((MediaPlayer)this.impl).isPlaying();
    }

    protected boolean playImpl() {
        this.audio.onPlaying(this);
        ((MediaPlayer)this.impl).seekTo(this.position);
        ((MediaPlayer)this.impl).start();
        this.position = 0;
        return true;
    }

    protected void stopImpl() {
        this.audio.onStopped(this);
        ((MediaPlayer)this.impl).pause();
    }

    protected void setLoopingImpl(boolean looping) {
        ((MediaPlayer)this.impl).setLooping(looping);
    }

    protected void setVolumeImpl(float volume) {
        ((MediaPlayer)this.impl).setVolume(volume, volume);
    }

    protected void releaseImpl() {
        if (((MediaPlayer)this.impl).isPlaying()) {
            ((MediaPlayer)this.impl).stop();
        }
        ((MediaPlayer)this.impl).release();
    }

    private void resolve() {
        this.resolver.resolve(this);
    }

    @Override
    void onPause() {
        if (this.impl != null) {
            if (((MediaPlayer)this.impl).isPlaying()) {
                this.position = ((MediaPlayer)this.impl).getCurrentPosition();
            }
            ((MediaPlayer)this.impl).release();
            this.impl = null;
        }
    }

    @Override
    void onResume() {
        this.resolve();
    }
}

