/*
 * Decompiled with CFR 0.152.
 */
package playn.android;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import java.util.LinkedList;
import playn.android.AndroidCanvasState;
import playn.android.AndroidGradient;
import playn.android.AndroidImage;
import playn.android.AndroidPath;
import playn.android.AndroidPattern;
import playn.android.AndroidTextLayout;
import playn.core.Canvas;
import playn.core.Gradient;
import playn.core.Graphics;
import playn.core.Image;
import playn.core.Path;
import playn.core.Pattern;
import playn.core.TextLayout;
import pythagoras.f.FloatMath;

public class AndroidCanvas
extends Canvas {
    private static Matrix m = new Matrix();
    private static Rect rect = new Rect();
    private static RectF rectf = new RectF();
    private final android.graphics.Canvas canvas;
    private final LinkedList<AndroidCanvasState> paintStack = new LinkedList();

    public AndroidCanvas(Graphics gfx, AndroidImage image) {
        super(gfx, (Image)image);
        this.canvas = new android.graphics.Canvas(image.bitmap());
        this.paintStack.addFirst(new AndroidCanvasState());
        float factor = image.scale().factor;
        this.scale(factor, factor);
    }

    void draw(Bitmap bitmap, float dx, float dy, float dw, float dh, float sx, float sy, float sw, float sh) {
        rect.set((int)sx, (int)sy, (int)(sx + sw), (int)(sy + sh));
        rectf.set(dx, dy, dx + dw, dy + dh);
        this.canvas.drawBitmap(bitmap, rect, rectf, this.currentState().prepareImage());
        this.isDirty = true;
    }

    public float alpha() {
        return this.currentState().alpha;
    }

    public Canvas clear() {
        this.canvas.drawColor(0, PorterDuff.Mode.SRC);
        this.isDirty = true;
        return this;
    }

    public Canvas clearRect(float x, float y, float width, float height) {
        this.canvas.save(2);
        this.canvas.clipRect(x, y, x + width, y + height);
        this.canvas.drawColor(0, PorterDuff.Mode.SRC);
        this.canvas.restore();
        this.isDirty = true;
        return this;
    }

    public Canvas clip(Path clipPath) {
        this.canvas.clipPath(((AndroidPath)clipPath).path);
        return this;
    }

    public Canvas clipRect(float x, float y, float width, float height) {
        this.canvas.clipRect(x, y, x + width, y + height);
        return this;
    }

    public Canvas drawLine(float x0, float y0, float x1, float y1) {
        this.canvas.drawLine(x0, y0, x1, y1, this.currentState().prepareStroke());
        this.isDirty = true;
        return this;
    }

    public Canvas drawPoint(float x, float y) {
        this.canvas.drawPoint(x, y, this.currentState().prepareStroke());
        this.isDirty = true;
        return this;
    }

    public Canvas drawArc(float cx, float cy, float r, float startAngle, float arcAngle) {
        float left = cx - r;
        float top = cy - r;
        float right = cx + r;
        float bottom = cy + r;
        rectf.set(left, top, right, bottom);
        this.canvas.drawArc(rectf, -FloatMath.toDegrees((float)startAngle), -FloatMath.toDegrees((float)arcAngle), false, this.currentState().prepareStroke());
        this.isDirty = true;
        return this;
    }

    public Canvas drawText(String text, float x, float y) {
        this.canvas.drawText(text, x, y, this.currentState().prepareFill());
        this.isDirty = true;
        return this;
    }

    public Canvas fillCircle(float x, float y, float radius) {
        this.canvas.drawCircle(x, y, radius, this.currentState().prepareFill());
        this.isDirty = true;
        return this;
    }

    public Canvas fillPath(Path path) {
        this.canvas.drawPath(((AndroidPath)path).path, this.currentState().prepareFill());
        this.isDirty = true;
        return this;
    }

    public Canvas fillRect(float x, float y, float width, float height) {
        float left = x;
        float top = y;
        float right = left + width;
        float bottom = top + height;
        this.canvas.drawRect(left, top, right, bottom, this.currentState().prepareFill());
        this.isDirty = true;
        return this;
    }

    public Canvas fillRoundRect(float x, float y, float width, float height, float radius) {
        this.canvas.translate(x, y);
        rectf.set(0.0f, 0.0f, width, height);
        this.canvas.drawRoundRect(rectf, radius, radius, this.currentState().prepareFill());
        this.canvas.translate(-x, -y);
        this.isDirty = true;
        return this;
    }

    public Canvas fillText(TextLayout layout, float x, float y) {
        ((AndroidTextLayout)layout).draw(this.canvas, x, y, this.currentState().prepareFill());
        this.isDirty = true;
        return this;
    }

    public Canvas restore() {
        this.canvas.restore();
        this.paintStack.removeFirst();
        assert (this.paintStack.size() > 0) : "Unbalanced save/restore";
        return this;
    }

    public Canvas rotate(float angle) {
        this.canvas.rotate(this.rad2deg(angle));
        return this;
    }

    public Canvas save() {
        this.canvas.save();
        this.paintStack.addFirst(new AndroidCanvasState(this.currentState()));
        return this;
    }

    public Canvas scale(float x, float y) {
        this.canvas.scale(x, y);
        return this;
    }

    public Canvas setAlpha(float alpha) {
        this.currentState().setAlpha(alpha);
        return this;
    }

    public Canvas setCompositeOperation(Canvas.Composite composite) {
        this.currentState().setCompositeOperation(composite);
        return this;
    }

    public Canvas setFillColor(int color) {
        this.currentState().setFillColor(color);
        return this;
    }

    public Canvas setFillGradient(Gradient gradient) {
        this.currentState().setFillGradient((AndroidGradient)gradient);
        return this;
    }

    public Canvas setFillPattern(Pattern pattern) {
        this.currentState().setFillPattern((AndroidPattern)pattern);
        return this;
    }

    public Canvas setLineCap(Canvas.LineCap cap) {
        this.currentState().setLineCap(cap);
        return this;
    }

    public Canvas setLineJoin(Canvas.LineJoin join) {
        this.currentState().setLineJoin(join);
        return this;
    }

    public Canvas setMiterLimit(float miter) {
        this.currentState().setMiterLimit(miter);
        return this;
    }

    public Canvas setStrokeColor(int color) {
        this.currentState().setStrokeColor(color);
        return this;
    }

    public Canvas setStrokeWidth(float strokeWidth) {
        this.currentState().setStrokeWidth(strokeWidth);
        return this;
    }

    public Image snapshot() {
        Bitmap bitmap = ((AndroidImage)this.image).bitmap();
        return new AndroidImage(this.gfx, this.image.scale(), bitmap.copy(bitmap.getConfig(), false), "<canvas>");
    }

    public Canvas strokeCircle(float x, float y, float radius) {
        this.canvas.drawCircle(x, y, radius, this.currentState().prepareStroke());
        this.isDirty = true;
        return this;
    }

    public Canvas strokePath(Path path) {
        this.canvas.drawPath(((AndroidPath)path).path, this.currentState().prepareStroke());
        this.isDirty = true;
        return this;
    }

    public Canvas strokeRect(float x, float y, float width, float height) {
        float left = x;
        float top = y;
        float right = left + width;
        float bottom = top + height;
        this.canvas.drawRect(left, top, right, bottom, this.currentState().prepareStroke());
        this.isDirty = true;
        return this;
    }

    public Canvas strokeRoundRect(float x, float y, float width, float height, float radius) {
        this.canvas.translate(x, y);
        rectf.set(0.0f, 0.0f, width, height);
        this.canvas.drawRoundRect(rectf, radius, radius, this.currentState().prepareStroke());
        this.canvas.translate(-x, -y);
        this.isDirty = true;
        return this;
    }

    public Canvas strokeText(TextLayout layout, float x, float y) {
        ((AndroidTextLayout)layout).draw(this.canvas, x, y, this.currentState().prepareStroke());
        this.isDirty = true;
        return this;
    }

    public Canvas transform(float m11, float m12, float m21, float m22, float dx, float dy) {
        m.setValues(new float[]{m11, m21, dx, m12, m22, dy, 0.0f, 0.0f, 1.0f});
        this.canvas.concat(m);
        return this;
    }

    public Canvas translate(float x, float y) {
        this.canvas.translate(x, y);
        return this;
    }

    protected AndroidCanvas gc() {
        return this;
    }

    private AndroidCanvasState currentState() {
        return this.paintStack.peek();
    }

    private float rad2deg(double deg) {
        return (float)(deg * 360.0 / (Math.PI * 2));
    }
}

