/*
 * Decompiled with CFR 0.152.
 */
package playn.android;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;
import playn.android.AndroidPlatform;
import playn.core.Input;
import playn.core.Key;
import playn.core.Keyboard;
import playn.core.Platform;
import playn.core.Touch;
import pythagoras.f.IPoint;
import react.RFuture;
import react.RPromise;

public class AndroidInput
extends Input {
    private final AndroidPlatform plat;
    private static Touch.Event.Kind[] TO_KIND = new Touch.Event.Kind[16];

    public AndroidInput(AndroidPlatform plat) {
        super((Platform)plat);
        this.plat = plat;
    }

    public boolean hasTouch() {
        return true;
    }

    public boolean hasHardwareKeyboard() {
        return false;
    }

    public RFuture<String> getText(final Keyboard.TextType ttype, final String label, final String initVal) {
        final RPromise result = this.plat.exec().deferredPromise();
        this.plat.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                int inputType;
                AlertDialog.Builder alert = new AlertDialog.Builder((Context)((AndroidInput)AndroidInput.this).plat.activity);
                alert.setMessage((CharSequence)label);
                final EditText input = new EditText((Context)((AndroidInput)AndroidInput.this).plat.activity);
                switch (ttype) {
                    case NUMBER: {
                        inputType = 4098;
                        break;
                    }
                    case EMAIL: {
                        inputType = 33;
                        break;
                    }
                    case URL: {
                        inputType = 17;
                        break;
                    }
                    default: {
                        inputType = 1;
                    }
                }
                input.setInputType(inputType);
                input.setText((CharSequence)initVal);
                alert.setView((View)input);
                alert.setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        result.succeed((Object)input.getText().toString());
                    }
                });
                alert.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        result.succeed(null);
                    }
                });
                alert.show();
            }
        });
        return result;
    }

    public RFuture<Boolean> sysDialog(final String title, final String text, final String ok, final String cancel) {
        final RPromise result = this.plat.exec().deferredPromise();
        this.plat.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AlertDialog.Builder alert = new AlertDialog.Builder((Context)((AndroidInput)AndroidInput.this).plat.activity).setTitle((CharSequence)title).setMessage((CharSequence)text);
                alert.setPositiveButton((CharSequence)ok, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        result.succeed((Object)true);
                    }
                });
                if (cancel != null) {
                    alert.setNegativeButton((CharSequence)cancel, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int whichButton) {
                            result.succeed((Object)false);
                        }
                    });
                }
                alert.show();
            }
        });
        return result;
    }

    void onKeyDown(int keyCode, KeyEvent nativeEvent) {
        long time = nativeEvent.getEventTime();
        Keyboard.KeyEvent event = new Keyboard.KeyEvent(0, (double)time, AndroidInput.keyForCode(keyCode), true);
        event.setFlag(this.mods(nativeEvent));
        this.dispatch((Keyboard.Event)event);
        int unicodeChar = nativeEvent.getUnicodeChar();
        if (unicodeChar != 0) {
            this.dispatch((Keyboard.Event)new Keyboard.TypedEvent(0, (double)time, (char)unicodeChar));
        }
    }

    void onKeyUp(int keyCode, KeyEvent nativeEvent) {
        long time = nativeEvent.getEventTime();
        Keyboard.KeyEvent event = new Keyboard.KeyEvent(0, (double)time, AndroidInput.keyForCode(keyCode), false);
        event.setFlag(this.mods(nativeEvent));
        this.dispatch((Keyboard.Event)event);
    }

    boolean onTouch(MotionEvent event) {
        Touch.Event.Kind kind;
        if (!this.touchEnabled) {
            return false;
        }
        int actionType = event.getActionMasked();
        Touch.Event.Kind kind2 = kind = actionType < TO_KIND.length ? TO_KIND[actionType] : null;
        if (kind != null) {
            final Touch.Event[] touches = this.parseMotionEvent(event, kind);
            this.plat.exec().invokeLater(new Runnable(){

                @Override
                public void run() {
                    AndroidInput.this.plat.dispatchEvent(AndroidInput.this.touchEvents, touches);
                }
            });
        }
        return kind != null;
    }

    private int mods(KeyEvent event) {
        return this.modifierFlags(event.isAltPressed(), event.isCtrlPressed(), event.isMetaPressed(), event.isShiftPressed());
    }

    private void dispatch(final Keyboard.Event event) {
        if (this.keyboardEnabled) {
            this.plat.exec().invokeLater(new Runnable(){

                @Override
                public void run() {
                    AndroidInput.this.plat.dispatchEvent(AndroidInput.this.keyboardEvents, event);
                }
            });
        }
    }

    private static Key keyForCode(int keyCode) {
        switch (keyCode) {
            case 7: {
                return Key.K0;
            }
            case 8: {
                return Key.K1;
            }
            case 9: {
                return Key.K2;
            }
            case 10: {
                return Key.K3;
            }
            case 11: {
                return Key.K4;
            }
            case 12: {
                return Key.K5;
            }
            case 13: {
                return Key.K6;
            }
            case 14: {
                return Key.K7;
            }
            case 15: {
                return Key.K8;
            }
            case 16: {
                return Key.K9;
            }
            case 29: {
                return Key.A;
            }
            case 57: {
                return Key.ALT;
            }
            case 58: {
                return Key.ALT;
            }
            case 75: {
                return Key.QUOTE;
            }
            case 77: {
                return Key.AT;
            }
            case 30: {
                return Key.B;
            }
            case 4: {
                return Key.BACK;
            }
            case 73: {
                return Key.BACKSLASH;
            }
            case 31: {
                return Key.C;
            }
            case 5: {
                return Key.CALL;
            }
            case 27: {
                return Key.CAMERA;
            }
            case 28: {
                return Key.CLEAR;
            }
            case 55: {
                return Key.COMMA;
            }
            case 32: {
                return Key.D;
            }
            case 67: {
                return Key.DELETE;
            }
            case 23: {
                return Key.DPAD_CENTER;
            }
            case 20: {
                return Key.DPAD_DOWN;
            }
            case 21: {
                return Key.DPAD_LEFT;
            }
            case 22: {
                return Key.DPAD_RIGHT;
            }
            case 19: {
                return Key.DPAD_UP;
            }
            case 33: {
                return Key.E;
            }
            case 6: {
                return Key.ENDCALL;
            }
            case 66: {
                return Key.ENTER;
            }
            case 65: {
                return Key.ENVELOPE;
            }
            case 70: {
                return Key.EQUALS;
            }
            case 64: {
                return Key.EXPLORER;
            }
            case 34: {
                return Key.F;
            }
            case 80: {
                return Key.FOCUS;
            }
            case 35: {
                return Key.G;
            }
            case 68: {
                return Key.BACKQUOTE;
            }
            case 36: {
                return Key.H;
            }
            case 79: {
                return Key.HEADSETHOOK;
            }
            case 3: {
                return Key.HOME;
            }
            case 37: {
                return Key.I;
            }
            case 38: {
                return Key.J;
            }
            case 39: {
                return Key.K;
            }
            case 40: {
                return Key.L;
            }
            case 71: {
                return Key.LEFT_BRACKET;
            }
            case 41: {
                return Key.M;
            }
            case 82: {
                return Key.MENU;
            }
            case 69: {
                return Key.MINUS;
            }
            case 91: {
                return Key.MUTE;
            }
            case 42: {
                return Key.N;
            }
            case 83: {
                return Key.NOTIFICATION;
            }
            case 78: {
                return Key.NUM;
            }
            case 43: {
                return Key.O;
            }
            case 44: {
                return Key.P;
            }
            case 93: {
                return Key.PAGE_DOWN;
            }
            case 92: {
                return Key.PAGE_UP;
            }
            case 56: {
                return Key.PERIOD;
            }
            case 94: {
                return Key.PICTSYMBOLS;
            }
            case 81: {
                return Key.PLUS;
            }
            case 18: {
                return Key.HASH;
            }
            case 26: {
                return Key.POWER;
            }
            case 45: {
                return Key.Q;
            }
            case 46: {
                return Key.R;
            }
            case 72: {
                return Key.RIGHT_BRACKET;
            }
            case 47: {
                return Key.S;
            }
            case 84: {
                return Key.SEARCH;
            }
            case 74: {
                return Key.SEMICOLON;
            }
            case 59: {
                return Key.SHIFT;
            }
            case 60: {
                return Key.SHIFT;
            }
            case 76: {
                return Key.SLASH;
            }
            case 1: {
                return Key.SOFT_LEFT;
            }
            case 2: {
                return Key.SOFT_RIGHT;
            }
            case 62: {
                return Key.SPACE;
            }
            case 17: {
                return Key.STAR;
            }
            case 95: {
                return Key.SWITCH_CHARSET;
            }
            case 63: {
                return Key.SYM;
            }
            case 48: {
                return Key.T;
            }
            case 61: {
                return Key.TAB;
            }
            case 49: {
                return Key.U;
            }
            case 0: {
                return Key.UNKNOWN;
            }
            case 50: {
                return Key.V;
            }
            case 25: {
                return Key.VOLUME_DOWN;
            }
            case 24: {
                return Key.VOLUME_UP;
            }
            case 51: {
                return Key.W;
            }
            case 52: {
                return Key.X;
            }
            case 53: {
                return Key.Y;
            }
            case 54: {
                return Key.Z;
            }
        }
        return Key.UNKNOWN;
    }

    private Touch.Event[] parseMotionEvent(MotionEvent event, Touch.Event.Kind kind) {
        int actionType = event.getActionMasked();
        boolean isChanged = actionType == 6 || actionType == 5;
        int changedIdx = isChanged ? event.getActionIndex() : 0;
        int count = event.getPointerCount();
        Touch.Event[] touches = new Touch.Event[isChanged ? 1 : count];
        double time = event.getEventTime();
        int tidx = 0;
        for (int tt = 0; tt < count; ++tt) {
            if (isChanged && tt != changedIdx) continue;
            IPoint xy = this.plat.graphics().transformTouch(event.getX(tt), event.getY(tt));
            float pressure = event.getPressure(tt);
            float size = event.getSize(tt);
            int id = event.getPointerId(tt) + 1;
            touches[tidx++] = new Touch.Event(0, time, xy.x(), xy.y(), kind, id, pressure, size);
        }
        return touches;
    }

    static {
        AndroidInput.TO_KIND[0] = Touch.Event.Kind.START;
        AndroidInput.TO_KIND[1] = Touch.Event.Kind.END;
        AndroidInput.TO_KIND[5] = Touch.Event.Kind.START;
        AndroidInput.TO_KIND[6] = Touch.Event.Kind.END;
        AndroidInput.TO_KIND[2] = Touch.Event.Kind.MOVE;
        AndroidInput.TO_KIND[3] = Touch.Event.Kind.CANCEL;
    }
}

