/*
 * Decompiled with CFR 0.152.
 */
package playn.android;

import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Xfermode;
import playn.android.AndroidGradient;
import playn.android.AndroidPattern;
import playn.core.Canvas;

class AndroidCanvasState {
    static PorterDuffXfermode[] xfermodes;
    static int PAINT_FLAGS;
    Paint paint;
    int fillColor;
    int strokeColor;
    AndroidGradient gradient;
    AndroidPattern pattern;
    float alpha;
    Canvas.Composite composite;

    AndroidCanvasState() {
        this(new Paint(PAINT_FLAGS), -16777216, -1, null, null, Canvas.Composite.SRC_OVER, 1.0f);
    }

    AndroidCanvasState(AndroidCanvasState toCopy) {
        this(AndroidCanvasState.copy(toCopy.paint), toCopy.fillColor, toCopy.strokeColor, toCopy.gradient, toCopy.pattern, toCopy.composite, toCopy.alpha);
    }

    AndroidCanvasState(Paint paint, int fillColor, int strokeColor, AndroidGradient gradient, AndroidPattern pattern, Canvas.Composite composite, float alpha) {
        this.paint = paint;
        this.fillColor = fillColor;
        this.strokeColor = strokeColor;
        this.gradient = gradient;
        this.pattern = pattern;
        this.composite = composite;
        this.alpha = alpha;
    }

    void setFillColor(int color) {
        this.fillColor = color;
    }

    void setFillGradient(AndroidGradient gradient) {
        this.gradient = gradient;
    }

    void setFillPattern(AndroidPattern pattern) {
        this.pattern = pattern;
    }

    void setLineCap(Canvas.LineCap cap) {
        this.paint.setStrokeCap(this.convertCap(cap));
    }

    void setLineJoin(Canvas.LineJoin join) {
        this.paint.setStrokeJoin(this.convertJoin(join));
    }

    void setMiterLimit(float miter) {
        this.paint.setStrokeMiter(miter);
    }

    void setStrokeColor(int color) {
        this.strokeColor = color;
    }

    void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    void setCompositeOperation(Canvas.Composite composite) {
        this.composite = composite;
    }

    void setStrokeWidth(float strokeWidth) {
        this.paint.setStrokeWidth(strokeWidth);
    }

    Paint prepareFill() {
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setXfermode(this.convertComposite(this.composite));
        if (this.gradient != null) {
            this.paint.setShader(this.gradient.shader);
        } else if (this.pattern != null) {
            this.paint.setShader((Shader)this.pattern.shader);
        } else {
            this.paint.setShader(null);
            this.paint.setColor(this.fillColor);
            if (this.alpha < 1.0f) {
                this.paint.setAlpha((int)(this.alpha * (float)(this.fillColor >>> 24)));
            }
        }
        return this.paint;
    }

    Paint prepareStroke() {
        this.paint.setShader(null);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setColor(this.strokeColor);
        if (this.alpha < 1.0f) {
            this.paint.setAlpha((int)(this.alpha * (float)(this.strokeColor >>> 24)));
        }
        this.paint.setXfermode(this.convertComposite(this.composite));
        return this.paint;
    }

    Paint prepareImage() {
        this.paint.setAlpha((int)(this.alpha * 255.0f));
        this.paint.setXfermode(this.convertComposite(this.composite));
        return this.paint;
    }

    private Paint.Cap convertCap(Canvas.LineCap cap) {
        switch (cap) {
            case BUTT: {
                return Paint.Cap.BUTT;
            }
            case ROUND: {
                return Paint.Cap.ROUND;
            }
            case SQUARE: {
                return Paint.Cap.SQUARE;
            }
        }
        return Paint.Cap.BUTT;
    }

    private Xfermode convertComposite(Canvas.Composite composite) {
        return xfermodes[composite.ordinal()];
    }

    private Paint.Join convertJoin(Canvas.LineJoin join) {
        switch (join) {
            case BEVEL: {
                return Paint.Join.BEVEL;
            }
            case MITER: {
                return Paint.Join.MITER;
            }
            case ROUND: {
                return Paint.Join.ROUND;
            }
        }
        return Paint.Join.MITER;
    }

    private static Paint copy(Paint source) {
        Paint clone = new Paint(PAINT_FLAGS);
        clone.set(source);
        return clone;
    }

    static {
        PAINT_FLAGS = 129;
        xfermodes = new PorterDuffXfermode[Canvas.Composite.values().length];
        for (Canvas.Composite composite : Canvas.Composite.values()) {
            AndroidCanvasState.xfermodes[composite.ordinal()] = new PorterDuffXfermode(PorterDuff.Mode.valueOf((String)composite.name()));
        }
    }
}

