/*
 * Decompiled with CFR 0.152.
 */
package playn.android;

import android.content.SharedPreferences;
import java.util.ArrayList;
import playn.android.AndroidPlatform;
import playn.core.BatchImpl;
import playn.core.Storage;

public class AndroidStorage
implements Storage {
    private SharedPreferences settings;

    public AndroidStorage(AndroidPlatform platform) {
        this.settings = platform.activity.getSharedPreferences(platform.activity.prefsName(), 0);
    }

    public void setItem(String key, String data) throws RuntimeException {
        this.settings.edit().putString(key, data).commit();
    }

    public void removeItem(String key) {
        this.settings.edit().remove(key).commit();
    }

    public String getItem(String key) {
        return this.settings.getString(key, null);
    }

    public Storage.Batch startBatch() {
        return new BatchImpl(this){
            private SharedPreferences.Editor edit;

            protected void onBeforeCommit() {
                this.edit = AndroidStorage.this.settings.edit();
            }

            protected void setImpl(String key, String data) {
                this.edit.putString(key, data);
            }

            protected void removeImpl(String key) {
                this.edit.remove(key);
            }

            protected void onAfterCommit() {
                this.edit.commit();
                this.edit = null;
            }
        };
    }

    public Iterable<String> keys() {
        return new ArrayList<String>(this.settings.getAll().keySet());
    }

    public boolean isPersisted() {
        return true;
    }
}

