/*
 * Decompiled with CFR 0.152.
 */
package playn.android;

import android.content.Intent;
import android.net.Uri;
import playn.android.AndroidAssets;
import playn.android.AndroidAudio;
import playn.android.AndroidExec;
import playn.android.AndroidGraphics;
import playn.android.AndroidInput;
import playn.android.AndroidLog;
import playn.android.AndroidNet;
import playn.android.AndroidStorage;
import playn.android.GameActivity;
import playn.core.Exec;
import playn.core.Game;
import playn.core.Json;
import playn.core.Platform;
import playn.core.json.JsonImpl;

public class AndroidPlatform
extends Platform {
    public static final boolean DEBUG_LOGS = false;
    Game game;
    GameActivity activity;
    private State state = State.RUNNING;
    private final AndroidAssets assets;
    private final AndroidAudio audio;
    private final AndroidExec exec;
    private final AndroidGraphics graphics;
    private final AndroidInput input;
    private final AndroidLog log;
    private final AndroidNet net;
    private final AndroidStorage storage;
    private final Json json;
    private final long start = System.nanoTime();

    public AndroidPlatform(GameActivity activity) {
        this.activity = activity;
        this.log = new AndroidLog(activity.logIdent());
        this.exec = new AndroidExec(this, activity){

            @Override
            protected boolean isPaused() {
                return AndroidPlatform.this.state == State.PAUSED;
            }
        };
        this.audio = new AndroidAudio(this);
        this.graphics = new AndroidGraphics(this, activity.preferredBitmapConfig(), activity.scaleFactor());
        this.assets = new AndroidAssets(this);
        this.json = new JsonImpl();
        this.input = new AndroidInput(this);
        this.net = new AndroidNet((Exec)this.exec);
        this.storage = new AndroidStorage(this);
    }

    static void debugLog(String message) {
    }

    public Platform.Type type() {
        return Platform.Type.ANDROID;
    }

    public double time() {
        return System.currentTimeMillis();
    }

    public int tick() {
        return (int)((System.nanoTime() - this.start) / 1000000L);
    }

    public void openURL(String url) {
        Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        this.activity.startActivity(browserIntent);
    }

    public AndroidAssets assets() {
        return this.assets;
    }

    public AndroidAudio audio() {
        return this.audio;
    }

    public AndroidGraphics graphics() {
        return this.graphics;
    }

    public AndroidInput input() {
        return this.input;
    }

    public AndroidLog log() {
        return this.log;
    }

    public AndroidNet net() {
        return this.net;
    }

    public AndroidStorage storage() {
        return this.storage;
    }

    public Exec exec() {
        return this.exec;
    }

    public Json json() {
        return this.json;
    }

    void onPause() {
        this.state = State.PAUSED;
        this.dispatchEvent(this.lifecycle, Platform.Lifecycle.PAUSE);
    }

    void onResume() {
        this.state = State.RUNNING;
        this.dispatchEvent(this.lifecycle, Platform.Lifecycle.RESUME);
    }

    void onExit() {
        this.state = State.EXITED;
        this.dispatchEvent(this.lifecycle, Platform.Lifecycle.EXIT);
    }

    void processFrame() {
        this.emitFrame();
    }

    private static enum State {
        RUNNING,
        PAUSED,
        EXITED;

    }
}

