/*
 * Decompiled with CFR 0.152.
 */
package playn.android;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;
import playn.android.AndroidWebSocket;
import playn.core.Exec;
import playn.core.Net;
import react.RFuture;
import react.RPromise;

public class AndroidNet
extends Net {
    private final Exec exec;

    public AndroidNet(Exec exec) {
        this.exec = exec;
    }

    public Net.WebSocket createWebSocket(String url, Net.WebSocket.Listener listener) {
        return new AndroidWebSocket(this.exec, url, listener);
    }

    protected RFuture<Net.Response> execute(final Net.Builder req) {
        final RPromise result = this.exec.deferredPromise();
        this.exec.invokeAsync(new Runnable(){

            @Override
            public void run() {
                BasicHttpParams params = new BasicHttpParams();
                HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
                HttpProtocolParams.setHttpElementCharset((HttpParams)params, (String)"UTF-8");
                DefaultHttpClient httpclient = new DefaultHttpClient((HttpParams)params);
                Object hreq = null;
                try {
                    Object impl;
                    if (req.isPost()) {
                        HttpPost httppost = new HttpPost(req.url);
                        if (req.payloadString != null) {
                            httppost.setEntity((HttpEntity)new StringEntity(req.payloadString, "UTF-8"));
                        } else if (req.payloadBytes != null) {
                            httppost.setEntity((HttpEntity)new ByteArrayEntity(req.payloadBytes));
                        }
                        hreq = httppost;
                        hreq.addHeader("Content-Type", req.contentType());
                    } else {
                        hreq = new HttpGet(req.url);
                    }
                    for (Net.Header header : req.headers) {
                        hreq.addHeader(header.name, header.value);
                    }
                    final HttpResponse response = httpclient.execute((HttpUriRequest)hreq);
                    int code = response.getStatusLine().getStatusCode();
                    HttpEntity entity = response.getEntity();
                    if (entity == null) {
                        impl = new Net.Response(code){

                            public String payloadString() {
                                return "";
                            }

                            public byte[] payload() {
                                return new byte[0];
                            }

                            protected Map<String, List<String>> extractHeaders() {
                                return this.extractResponseHeaders(response);
                            }
                        };
                    } else {
                        byte[] data = EntityUtils.toByteArray((HttpEntity)entity);
                        String encoding = EntityUtils.getContentCharSet((HttpEntity)entity);
                        if (encoding == null) {
                            encoding = "UTF-8";
                        }
                        impl = new Net.Response.Binary(code, data, encoding){

                            protected Map<String, List<String>> extractHeaders() {
                                return this.extractResponseHeaders(response);
                            }
                        };
                    }
                    result.succeed(impl);
                }
                catch (Throwable t) {
                    result.fail(t);
                }
            }

            public String toString() {
                return "AndroidNet.exec(" + req.method() + ", " + req.url + ")";
            }

            private Map<String, List<String>> extractResponseHeaders(HttpResponse response) {
                HashMap<String, List<String>> hmap = new HashMap<String, List<String>>();
                for (Header header : response.getAllHeaders()) {
                    String name = header.getName();
                    ArrayList<String> values = (ArrayList<String>)hmap.get(name);
                    if (values == null) {
                        values = new ArrayList<String>();
                        hmap.put(name, values);
                    }
                    values.add(header.getValue());
                }
                return hmap;
            }
        });
        return result;
    }
}

