/*
 * Decompiled with CFR 0.152.
 */
package playn.android;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.opengl.GLUtils;
import playn.android.AndroidBitmapTransformer;
import playn.android.AndroidCanvas;
import playn.android.AndroidPattern;
import playn.android.AndroidPlatform;
import playn.core.Graphics;
import playn.core.Image;
import playn.core.ImageImpl;
import playn.core.Pattern;
import playn.core.Platform;
import playn.core.Scale;
import playn.core.Texture;

public class AndroidImage
extends ImageImpl {
    protected Bitmap bitmap;

    public AndroidImage(Graphics gfx, Scale scale, Bitmap bitmap, String source) {
        super(gfx, scale, bitmap.getWidth(), bitmap.getHeight(), source, (Object)bitmap);
    }

    public AndroidImage(AndroidPlatform plat, boolean async, int preWidth, int preHeight, String source) {
        super((Platform)plat, async, Scale.ONE, preWidth, preHeight, source);
    }

    public Bitmap bitmap() {
        return this.bitmap;
    }

    public Pattern createPattern(boolean repeatX, boolean repeatY) {
        return new AndroidPattern(repeatX, repeatY, this.bitmap);
    }

    public void getRgb(int startX, int startY, int width, int height, int[] rgbArray, int offset, int scanSize) {
        this.bitmap.getPixels(rgbArray, offset, scanSize, startX, startY, width, height);
    }

    public void setRgb(int startX, int startY, int width, int height, int[] rgbArray, int offset, int scanSize) {
        this.bitmap.setPixels(rgbArray, offset, scanSize, startX, startY, width, height);
    }

    public Image transform(Image.BitmapTransformer xform) {
        Bitmap nbitmap = ((AndroidBitmapTransformer)xform).transform(this.bitmap);
        return new AndroidImage(this.gfx, this.scale, nbitmap, this.source);
    }

    public void draw(Object ctx, float x, float y, float w, float h) {
        this.draw(ctx, x, y, w, h, 0.0f, 0.0f, this.width(), this.height());
    }

    public void draw(Object ctx, float dx, float dy, float dw, float dh, float sx, float sy, float sw, float sh) {
        ((AndroidCanvas)((Object)ctx)).draw(this.bitmap, dx, dy, dw, dh, sx *= this.scale.factor, sy *= this.scale.factor, sw *= this.scale.factor, sh *= this.scale.factor);
    }

    public String toString() {
        return "Image[src=" + this.source + ", bitmap=" + this.bitmap + "]";
    }

    protected void upload(Graphics gfx, Texture tex) {
        gfx.gl.glBindTexture(3553, tex.id);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)this.bitmap, (int)0);
        gfx.gl.checkError("updateTexture end");
    }

    protected void setBitmap(Object bitmap) {
        this.bitmap = (Bitmap)bitmap;
    }

    protected Object createErrorBitmap(int pixelWidth, int pixelHeight) {
        Bitmap bitmap = Bitmap.createBitmap((int)pixelWidth, (int)pixelHeight, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas c = new Canvas(bitmap);
        Paint p = new Paint();
        p.setColor(-65536);
        for (int yy = 0; yy <= pixelHeight / 15; ++yy) {
            for (int xx = 0; xx <= pixelWidth / 45; ++xx) {
                c.drawText("ERROR", (float)(xx * 45), (float)(yy * 15), p);
            }
        }
        return bitmap;
    }
}

