/*
 * Decompiled with CFR 0.152.
 */
package playn.android;

import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import android.media.SoundPool;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import playn.android.AndroidCompressedSound;
import playn.android.AndroidPlatform;
import playn.android.AndroidSound;
import playn.core.Audio;
import playn.core.SoundImpl;

public class AndroidAudio
extends Audio {
    final AndroidPlatform plat;
    private final Set<AndroidSound<?>> playing = new HashSet();
    private final Map<Integer, PooledSound> loadingSounds = new HashMap<Integer, PooledSound>();
    private final SoundPool pool;

    public AndroidAudio(final AndroidPlatform plat) {
        this.plat = plat;
        this.pool = new SoundPool(plat.activity.maxSimultaneousSounds(), 3, 0);
        this.pool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(){

            public void onLoadComplete(SoundPool soundPool, int soundId, int status) {
                PooledSound sound = (PooledSound)((Object)AndroidAudio.this.loadingSounds.remove(soundId));
                if (sound == null) {
                    plat.log().warn("Got load complete for unknown sound [id=" + soundId + "]");
                } else if (status == 0) {
                    sound.succeed(soundId);
                } else {
                    sound.fail(new Exception("Sound load failed [errcode=" + status + "]"));
                }
            }
        });
    }

    public SoundImpl<?> createSound(AssetFileDescriptor fd) {
        PooledSound sound = new PooledSound(this.pool.load(fd, 1));
        this.loadingSounds.put(sound.soundId, sound);
        return sound;
    }

    public SoundImpl<?> createSound(FileDescriptor fd, long offset, long length) {
        PooledSound sound = new PooledSound(this.pool.load(fd, offset, length, 1));
        this.loadingSounds.put(sound.soundId, sound);
        return sound;
    }

    SoundImpl<?> createSound(String path) {
        try {
            return this.createSound(this.plat.assets().openAssetFd(path));
        }
        catch (IOException ioe) {
            PooledSound sound = new PooledSound(0);
            sound.fail(ioe);
            return sound;
        }
    }

    AndroidSound<?> createMusic(final String path) {
        return new AndroidCompressedSound(this, new Resolver<MediaPlayer>(){

            @Override
            public void resolve(final AndroidSound<MediaPlayer> sound) {
                final MediaPlayer mp = new MediaPlayer();
                AndroidAudio.this.plat.exec().invokeAsync(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AssetFileDescriptor fd = AndroidAudio.this.plat.assets().openAssetFd(path);
                            mp.setDataSource(fd.getFileDescriptor(), fd.getStartOffset(), fd.getLength());
                            fd.close();
                            mp.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                                public void onPrepared(MediaPlayer mp) {
                                    sound.succeed(mp);
                                }
                            });
                            mp.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                                public boolean onError(MediaPlayer mp, int what, int extra) {
                                    String errmsg = "MediaPlayer prepare fail [what=" + what + ", x=" + extra + "]";
                                    AndroidAudio.this.plat.log().warn(errmsg);
                                    sound.fail(new Exception(errmsg));
                                    return false;
                                }
                            });
                            mp.prepareAsync();
                        }
                        catch (Throwable t) {
                            AndroidAudio.this.plat.reportError("Sound load error '" + path + "'", t);
                            sound.fail(t);
                        }
                    }
                });
            }
        });
    }

    public void onPause() {
        this.pool.autoPause();
        if (!this.playing.isEmpty()) {
            AndroidPlatform.debugLog("Pausing " + this.playing.size() + " playing sounds.");
        }
        for (AndroidSound<?> sound : this.playing) {
            sound.onPause();
        }
    }

    public void onResume() {
        this.pool.autoResume();
        HashSet wasPlaying = new HashSet(this.playing);
        this.playing.clear();
        if (!wasPlaying.isEmpty()) {
            AndroidPlatform.debugLog("Resuming " + wasPlaying.size() + " playing sounds.");
        }
        for (AndroidSound androidSound : wasPlaying) {
            androidSound.onResume();
        }
    }

    public void onDestroy() {
        for (AndroidSound<?> sound : this.playing) {
            sound.release();
        }
        this.playing.clear();
        this.pool.release();
    }

    void onPlaying(AndroidSound<?> sound) {
        AndroidPlatform.debugLog("Playing " + sound);
        this.playing.add(sound);
    }

    void onStopped(AndroidSound<?> sound) {
        AndroidPlatform.debugLog("Stopped " + sound);
        this.playing.remove(sound);
    }

    private class PooledSound
    extends SoundImpl<Integer> {
        public final int soundId;
        private int streamId;

        public PooledSound(int soundId) {
            super(AndroidAudio.this.plat.exec());
            this.soundId = soundId;
        }

        public String toString() {
            return "pooled:" + this.soundId;
        }

        protected boolean playingImpl() {
            return false;
        }

        protected boolean playImpl() {
            this.streamId = AndroidAudio.this.pool.play(this.soundId, this.volume, this.volume, 1, this.looping ? -1 : 0, 1.0f);
            return this.streamId != 0;
        }

        protected boolean prepareImpl() {
            AndroidAudio.this.pool.play(this.soundId, 0.0f, 0.0f, 0, 0, 1.0f);
            return true;
        }

        protected void stopImpl() {
            if (this.streamId != 0) {
                AndroidAudio.this.pool.stop(this.streamId);
                this.streamId = 0;
            }
        }

        protected void setLoopingImpl(boolean looping) {
            if (this.streamId != 0) {
                AndroidAudio.this.pool.setLoop(this.streamId, looping ? -1 : 0);
            }
        }

        protected void setVolumeImpl(float volume) {
            if (this.streamId != 0) {
                AndroidAudio.this.pool.setVolume(this.streamId, volume, volume);
            }
        }

        protected void releaseImpl() {
            AndroidAudio.this.pool.unload(this.soundId);
        }
    }

    protected static interface Resolver<I> {
        public void resolve(AndroidSound<I> var1);
    }
}

