/*
 * Decompiled with CFR 0.152.
 */
package playn.android;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Typeface;
import com.android.vending.expansion.zipfile.APKExpansionSupport;
import com.android.vending.expansion.zipfile.ZipResourceFile;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import playn.android.AndroidHttpClient;
import playn.android.AndroidImage;
import playn.android.AndroidPlatform;
import playn.core.Assets;
import playn.core.Image;
import playn.core.ImageImpl;
import playn.core.Scale;
import playn.core.Sound;

public class AndroidAssets
extends Assets {
    private final AndroidPlatform plat;
    private final AssetManager assetMgr;
    private String pathPrefix = "";
    private Scale assetScale = null;
    private ZipResourceFile expansionFile = null;
    private BitmapOptionsAdjuster optionsAdjuster = new BitmapOptionsAdjuster(){

        @Override
        public void adjustOptions(String path, BitmapOptions options) {
        }
    };

    public AndroidAssets(AndroidPlatform plat) {
        super(plat.exec());
        this.plat = plat;
        this.assetMgr = plat.activity.getResources().getAssets();
    }

    public void setPathPrefix(String prefix) {
        if (prefix.startsWith("/") || prefix.endsWith("/")) {
            throw new IllegalArgumentException("Prefix must not start or end with '/'.");
        }
        this.pathPrefix = prefix.length() == 0 ? prefix : prefix + "/";
    }

    public void setExpansionFile(int mainVersion, int patchVersion) throws IOException {
        this.expansionFile = APKExpansionSupport.getAPKExpansionZipFile((Context)this.plat.activity, (int)mainVersion, (int)patchVersion);
        if (this.expansionFile == null) {
            throw new FileNotFoundException("Missing APK expansion zip files");
        }
    }

    public void setAssetScale(float scaleFactor) {
        this.assetScale = new Scale(scaleFactor);
    }

    public void setBitmapOptionsAdjuster(BitmapOptionsAdjuster optionsAdjuster) {
        this.optionsAdjuster = optionsAdjuster;
    }

    public Typeface getTypeface(String path) {
        return Typeface.createFromAsset((AssetManager)this.assetMgr, (String)AndroidAssets.normalizePath((String)(this.pathPrefix + path)));
    }

    public Image getRemoteImage(final String url, int width, int height) {
        final ImageImpl image = this.createImage(true, width, height, url);
        this.exec.invokeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    BitmapOptions options = AndroidAssets.this.createOptions(url, false, Scale.ONE);
                    Bitmap bmp = AndroidAssets.this.downloadBitmap(url, options);
                    image.succeed(new ImageImpl.Data(options.scale, (Object)bmp, bmp.getWidth(), bmp.getHeight()));
                }
                catch (Throwable error) {
                    image.fail(error);
                }
            }
        });
        return image;
    }

    public Sound getSound(String path) {
        return this.plat.audio().createSound(path + ".mp3");
    }

    public Sound getMusic(String path) {
        return this.plat.audio().createMusic(path + ".mp3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTextSync(String path) throws Exception {
        try (InputStream is = this.openAsset(path);){
            StringBuilder fileData = new StringBuilder(1000);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
            }
            reader.close();
            String string = fileData.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytesSync(String path) throws Exception {
        try (InputStream is = this.openAsset(path);){
            int r;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((r = is.read(buf)) != -1) {
                out.write(buf, 0, r);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    protected ImageImpl createImage(boolean async, int rwid, int rhei, String source) {
        return new AndroidImage(this.plat, async, rwid, rhei, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImageImpl.Data load(String path) throws Exception {
        Exception error = null;
        for (Scale.ScaledResource rsrc : this.assetScale().getScaledResources(path)) {
            ImageImpl.Data data;
            InputStream is = this.openAsset(rsrc.path);
            try {
                BitmapOptions options = this.createOptions(path, true, rsrc.scale);
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
                data = new ImageImpl.Data(options.scale, (Object)bitmap, bitmap.getWidth(), bitmap.getHeight());
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (FileNotFoundException fnfe) {
                    error = fnfe;
                    continue;
                }
                catch (Exception e) {
                    error = e;
                    break;
                }
            }
            is.close();
            return data;
        }
        this.plat.reportError("Could not load image: " + this.pathPrefix + path, error);
        throw error != null ? error : new FileNotFoundException(path);
    }

    protected AssetFileDescriptor openAssetFd(String path) throws IOException {
        String fullPath = AndroidAssets.normalizePath((String)(this.pathPrefix + path));
        return this.expansionFile == null ? this.assetMgr.openFd(fullPath) : this.expansionFile.getAssetFileDescriptor(fullPath);
    }

    protected Scale assetScale() {
        return this.assetScale != null ? this.assetScale : this.plat.graphics().scale();
    }

    protected InputStream openAsset(String path) throws IOException {
        InputStream is;
        String fullPath = AndroidAssets.normalizePath((String)(this.pathPrefix + path));
        InputStream inputStream = is = this.expansionFile == null ? this.assetMgr.open(fullPath, 2) : this.expansionFile.getInputStream(fullPath);
        if (is == null) {
            throw new FileNotFoundException("Missing resource: " + fullPath);
        }
        return is;
    }

    protected BitmapOptions createOptions(String path, boolean purgeable, Scale scale) {
        BitmapOptions options = new BitmapOptions();
        options.inScaled = false;
        options.inDither = true;
        options.inPreferredConfig = this.plat.graphics().preferredBitmapConfig;
        options.inPurgeable = purgeable;
        options.inInputShareable = true;
        options.scale = scale;
        this.optionsAdjuster.adjustOptions(path, options);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bitmap downloadBitmap(String url, BitmapOptions options) throws Exception {
        HttpGet getRequest = new HttpGet(url);
        try (AndroidHttpClient client = AndroidHttpClient.newInstance("Android");){
            Bitmap bitmap;
            HttpEntity entity;
            block13: {
                HttpResponse response = client.execute((HttpUriRequest)getRequest);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    Header[] headers = response.getHeaders("Location");
                    if (headers != null && headers.length > 0) {
                        Bitmap bitmap2 = this.downloadBitmap(headers[headers.length - 1].getValue(), options);
                        return bitmap2;
                    }
                    throw new Exception("Error " + statusCode + " while retrieving bitmap from " + url);
                }
                entity = response.getEntity();
                if (entity == null) {
                    throw new Exception("Error: getEntity returned null for " + url);
                }
                InputStream inputStream = null;
                try {
                    inputStream = entity.getContent();
                    bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
                    if (inputStream == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        entity.consumeContent();
                        throw throwable;
                    }
                    catch (Exception e) {
                        getRequest.abort();
                        this.plat.reportError("Error while retrieving bitmap from " + url, e);
                        throw e;
                    }
                }
                inputStream.close();
            }
            entity.consumeContent();
            return bitmap;
        }
    }

    public static interface BitmapOptionsAdjuster {
        public void adjustOptions(String var1, BitmapOptions var2);
    }

    public class BitmapOptions
    extends BitmapFactory.Options {
        public Scale scale;
    }
}

