/*
 * Decompiled with CFR 0.152.
 */
package io.pity.api.execution;

import com.google.inject.Inject;
import io.pity.api.WorkingDirectoryProvider;
import io.pity.api.execution.CommandExecutionResultBuilder;
import io.pity.api.execution.CommandExecutor;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;

public abstract class AbstractCommandExecutor
implements CommandExecutor {
    final WorkingDirectoryProvider workingDirectoryProvider;
    protected final File tempDir;
    public final CommandExecutionResultBuilder commandExecutionResultBuilder;

    @Inject
    public AbstractCommandExecutor(WorkingDirectoryProvider workingDirectoryProvider) throws IOException {
        this.workingDirectoryProvider = workingDirectoryProvider;
        this.tempDir = new File(FileUtils.getTempDirectory(), "pity_" + RandomStringUtils.randomAlphanumeric((int)10));
        FileUtils.forceMkdir((File)this.tempDir);
        this.commandExecutionResultBuilder = new CommandExecutionResultBuilder(this.getClass().getSimpleName(), this.tempDir);
    }

    public File getWorkingDirectory() {
        return this.workingDirectoryProvider.getWorkingDirectory();
    }
}

