/*
 * Decompiled with CFR 0.152.
 */
package io.pity.api.environment;

import com.google.inject.Inject;
import io.pity.api.WorkingDirectoryProvider;
import io.pity.api.environment.EnvironmentData;
import io.pity.api.environment.EnvironmentDataBuilder;
import java.io.File;

public abstract class EnvironmentCollector {
    public final WorkingDirectoryProvider workingDirectoryProvider;
    public final EnvironmentDataBuilder environmentDataBuilder = EnvironmentDataBuilder.Builder(this.getClass().getSimpleName());

    @Inject
    public EnvironmentCollector(WorkingDirectoryProvider workingDirectoryProvider) {
        this.workingDirectoryProvider = workingDirectoryProvider;
    }

    public final File getWorkingDirectory() {
        return this.workingDirectoryProvider.getWorkingDirectory();
    }

    public abstract boolean shouldCollect();

    public abstract void collect();

    public final EnvironmentData collectEnvironmentData() {
        if (this.shouldCollect()) {
            this.collect();
        }
        return this.environmentDataBuilder.build();
    }
}

