/*
 * Decompiled with CFR 0.152.
 */
package io.percy.selenium;

import io.percy.selenium.Environment;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public class Percy {
    private static final Logger LOGGER = Logger.getLogger(Percy.class.getName());
    private static final String AGENTJS_FILE = "percy-agent.js";
    private WebDriver driver;
    private String percyAgentJs;
    private String environmentDictString;

    public Percy(WebDriver driver) {
        this.driver = driver;
        this.percyAgentJs = this.loadPercyAgentJs();
        this.environmentDictString = new Environment(driver).getInfoDict();
    }

    @Nullable
    private String loadPercyAgentJs() {
        try {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(AGENTJS_FILE);
            byte[] agentBytes = new byte[stream.available()];
            stream.read(agentBytes);
            return new String(agentBytes);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Something went wrong trying to load {}. Snapshotting will not work.", AGENTJS_FILE);
            return null;
        }
    }

    public void snapshot(String name) {
        this.snapshot(name, null, null);
    }

    public void snapshot(String name, List<Integer> widths) {
        this.snapshot(name, widths, null);
    }

    public void snapshot(String name, @Nullable List<Integer> widths, Integer minHeight) {
        if (this.percyAgentJs == null) {
            LOGGER.log(Level.WARNING, "percy-agent.js is not available. Snapshotting is disabled.");
            return;
        }
        try {
            JavascriptExecutor jse = (JavascriptExecutor)this.driver;
            jse.executeScript(this.percyAgentJs, new Object[0]);
            jse.executeScript(this.buildSnapshotJS(name, widths, minHeight), new Object[0]);
        }
        catch (WebDriverException e) {
            LOGGER.log(Level.WARNING, "Something went wrong attempting to take a snapshot: {}", e.getMessage());
        }
    }

    private String buildSnapshotJS(String name, List<Integer> widths, Integer minHeight) {
        StringBuilder jsBuilder = new StringBuilder();
        jsBuilder.append(String.format("const percyAgentClient = new PercyAgent(%s)\n", this.environmentDictString));
        ArrayList<String> snapshotParams = new ArrayList<String>(Arrays.asList(String.format("'%s'", name)));
        String optionalParams = this.maybeBuildOptionalParamsString(widths, minHeight);
        if (optionalParams != null) {
            snapshotParams.add(optionalParams);
        }
        jsBuilder.append(String.format("percyAgentClient.snapshot(%s)", String.join((CharSequence)",", snapshotParams)));
        return jsBuilder.toString();
    }

    @Nullable
    private String maybeBuildOptionalParamsString(@Nullable List<Integer> widths, @Nullable Integer minHeight) {
        ArrayList<String> stringifiedParams = new ArrayList<String>();
        if (widths != null) {
            stringifiedParams.add(String.format("widths: %s", widths));
        }
        if (minHeight != null) {
            stringifiedParams.add(String.format("minHeight: %s", minHeight));
        }
        if (stringifiedParams.isEmpty()) {
            return null;
        }
        return String.format("{ %s }", String.join((CharSequence)",", stringifiedParams));
    }
}

