/*
 * Decompiled with CFR 0.152.
 */
package io.percy.appium.providers;

import io.appium.java_client.AppiumDriver;
import io.percy.appium.AppPercy;
import io.percy.appium.Environment;
import io.percy.appium.lib.ScreenshotOptions;
import io.percy.appium.lib.Tile;
import io.percy.appium.providers.GenericProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class AppAutomate
extends GenericProvider {
    private AppiumDriver driver;
    private Boolean markedPercySession = true;

    public AppAutomate(AppiumDriver driver) {
        super(driver);
        this.driver = driver;
    }

    public String getDebugUrl(JSONObject result) {
        if (result == null) {
            return null;
        }
        String buildHash = result.getString("buildHash");
        String sessionHash = result.getString("sessionHash");
        return "https://app-automate.browserstack.com/dashboard/v2/builds/" + buildHash + "/sessions/" + sessionHash;
    }

    public static Boolean supports(AppiumDriver driver) {
        String remoteAddress = driver.getRemoteAddress().getHost().toString();
        if (remoteAddress.contains(System.getenv("AA_DOMAIN") != null ? System.getenv("AA_DOMAIN") : "browserstack")) {
            return true;
        }
        return false;
    }

    public JSONObject executePercyScreenshotBegin(String name) {
        try {
            if (this.markedPercySession.booleanValue()) {
                JSONObject arguments = new JSONObject();
                arguments.put("state", (Object)"begin");
                arguments.put("percyBuildId", (Object)Environment.getPercyBuildID());
                arguments.put("percyBuildUrl", (Object)Environment.getPercyBuildUrl());
                arguments.put("name", (Object)name);
                JSONObject reqObject = new JSONObject();
                reqObject.put("action", (Object)"percyScreenshot");
                reqObject.put("arguments", (Object)arguments);
                String resultString = this.driver.executeScript(String.format("browserstack_executor: %s", reqObject.toString()), new Object[0]).toString();
                JSONObject result = new JSONObject(resultString);
                this.markedPercySession = result.get("success").toString() == "true";
                return result;
            }
        }
        catch (Exception e) {
            AppPercy.log("BrowserStack executer failed");
        }
        return null;
    }

    public void executePercyScreenshotEnd(String name, String percyScreenshotUrl, String error) {
        try {
            if (this.markedPercySession.booleanValue()) {
                String status = "success";
                if (error != null) {
                    status = "Failed: " + error;
                }
                JSONObject arguments = new JSONObject();
                arguments.put("state", (Object)"end");
                arguments.put("percyScreenshotUrl", (Object)percyScreenshotUrl);
                arguments.put("name", (Object)name);
                arguments.put("status", (Object)status);
                JSONObject reqObject = new JSONObject();
                reqObject.put("action", (Object)"percyScreenshot");
                reqObject.put("arguments", (Object)arguments);
                String resultString = this.driver.executeScript(String.format("browserstack_executor: %s", reqObject.toString()), new Object[0]).toString();
                JSONObject result = new JSONObject(resultString);
                this.markedPercySession = result.get("success").toString() == "true";
            }
        }
        catch (Exception e) {
            AppPercy.log("BrowserStack executer failed");
        }
    }

    public String executePercyScreenshot(ScreenshotOptions options, Integer scaleFactor, Integer deviceHeight) throws Exception {
        try {
            String screenshotType = "fullpage";
            if (!options.getFullPage().booleanValue() || !this.verifyCorrectAppiumVersion().booleanValue()) {
                screenshotType = "singlepage";
            }
            String projectId = "percy-prod";
            if (Environment.getEnablePercyDev().booleanValue()) {
                projectId = "percy-dev";
            }
            JSONObject arguments = new JSONObject();
            JSONObject args = new JSONObject();
            args.put("numOfTiles", (Object)options.getScreenLengths());
            args.put("deviceHeight", (Object)deviceHeight);
            args.put("scollableXpath", (Object)options.getScrollableXpath());
            args.put("scrollableId", (Object)options.getScrollableId());
            args.put("FORCE_FULL_PAGE", (Object)Environment.getForceFullPage());
            arguments.put("state", (Object)"screenshot");
            arguments.put("percyBuildId", (Object)Environment.getPercyBuildID());
            arguments.put("screenshotType", (Object)screenshotType);
            arguments.put("scaleFactor", (Object)scaleFactor);
            arguments.put("projectId", (Object)projectId);
            arguments.put("options", (Object)args);
            JSONObject reqObject = new JSONObject();
            reqObject.put("action", (Object)"percyScreenshot");
            reqObject.put("arguments", (Object)arguments);
            String resultString = this.driver.executeScript(String.format("browserstack_executor: %s", reqObject.toString()), new Object[0]).toString();
            JSONObject result = new JSONObject(resultString);
            return result.get("result").toString();
        }
        catch (Exception e) {
            throw new Exception("Screenshot command failed");
        }
    }

    @Override
    public List<Tile> captureTiles(ScreenshotOptions options) throws Exception {
        if (Environment.getDisableRemoteUploads().booleanValue()) {
            if (options.getFullPage().booleanValue()) {
                AppPercy.log("Full page screenshots are only supported when \"PERCY_DISABLE_REMOTE_UPLOADS\" is not set", "warn");
            }
            return super.captureTiles(options);
        }
        Integer statusBar = this.getMetadata().statBarHeight();
        Integer navBar = this.getMetadata().navBarHeight();
        String response = this.executePercyScreenshot(options, this.getMetadata().scaleFactor(), this.getMetadata().deviceScreenHeight());
        JSONArray jsonarray = new JSONArray(response);
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        for (int i = 0; i < jsonarray.length(); ++i) {
            JSONObject jsonobject = jsonarray.getJSONObject(i);
            String sha = jsonobject.getString("sha").split("-")[0];
            Integer headerHeight = jsonobject.getInt("header_height");
            Integer footerHeight = jsonobject.getInt("footer_height");
            tiles.add(new Tile(null, statusBar, navBar, headerHeight, footerHeight, options.getFullScreen(), sha));
        }
        return tiles;
    }

    @Override
    public String screenshot(String name, ScreenshotOptions options) {
        JSONObject result = this.executePercyScreenshotBegin(name);
        String percyScreenshotUrl = "";
        String error = null;
        String device = this.deviceName(options.getDeviceName(), result);
        String osVersion = this.osVersion(result);
        super.setDebugUrl(this.getDebugUrl(result));
        try {
            percyScreenshotUrl = super.screenshot(name, options, osVersion, device);
        }
        catch (Exception e) {
            error = e.getMessage();
        }
        this.executePercyScreenshotEnd(name, percyScreenshotUrl, error);
        return null;
    }

    public String osVersion(JSONObject result) {
        return result != null ? result.getString("osVersion").split("\\.")[0] : null;
    }

    public String deviceName(String deviceName, JSONObject result) {
        if (deviceName != null) {
            return deviceName;
        }
        return result != null ? result.getString("deviceName") : null;
    }

    public Boolean verifyCorrectAppiumVersion() {
        Map bstackOptions = (Map)this.driver.getCapabilities().getCapability("bstack:options");
        Object appiumVersionJsonProtocol = this.driver.getCapabilities().getCapability("browserstack.appium_version");
        if (bstackOptions == null && appiumVersionJsonProtocol == null) {
            AppPercy.log("Unable to fetch Appium version, Appium version should be >= 1.19 for Fullpage Screenshot", "warn");
        } else if (appiumVersionJsonProtocol != null && !this.appiumVersionCheck(appiumVersionJsonProtocol.toString()).booleanValue() || bstackOptions != null && !this.appiumVersionCheck(bstackOptions.get("appiumVersion").toString()).booleanValue()) {
            AppPercy.log("Appium version should be >= 1.19 for Fullpage Screenshot, Falling back to single page screenshot.", "warn");
            return false;
        }
        return true;
    }

    private Boolean appiumVersionCheck(String appiumVersion) {
        Integer majorVersion = Integer.parseInt(appiumVersion.split("\\.")[0]);
        Integer minorVersion = Integer.parseInt(appiumVersion.split("\\.")[1]);
        if (majorVersion == 2 || majorVersion == 1 && minorVersion > 18) {
            return true;
        }
        return false;
    }
}

