/*
 * Decompiled with CFR 0.152.
 */
package io.percy.appium.metadata;

import io.appium.java_client.AppiumDriver;
import io.appium.java_client.ios.IOSDriver;
import io.percy.appium.lib.Cache;
import io.percy.appium.metadata.Metadata;
import io.percy.appium.metadata.MetadataHelper;
import java.util.Map;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpMethod;

public class IosMetadata
extends Metadata {
    private IOSDriver driver;
    private String sessionId;

    public IosMetadata(AppiumDriver driver, String deviceName, Integer statusBar, Integer navBar, String orientation, String platformVersion) {
        super(driver, deviceName, statusBar, navBar, orientation, platformVersion);
        this.driver = (IOSDriver)driver;
        this.sessionId = driver.getSessionId().toString();
    }

    @Override
    public String deviceName() {
        String deviceName = this.getDeviceName();
        if (deviceName != null) {
            return deviceName;
        }
        return this.driver.getCapabilities().getCapability("deviceName").toString();
    }

    @Override
    public String osName() {
        String osName = this.driver.getCapabilities().getCapability("platformName").toString();
        return osName.substring(0, 1).toLowerCase() + osName.substring(1).toUpperCase();
    }

    @Override
    public Integer deviceScreenWidth() {
        Integer deviceScreenWidth = MetadataHelper.valueFromStaticDevicesInfo("screenWidth", this.deviceName().toLowerCase());
        if (deviceScreenWidth == 0) {
            deviceScreenWidth = ((Long)this.getViewportRect().get("width")).intValue();
        }
        return deviceScreenWidth;
    }

    @Override
    public Integer deviceScreenHeight() {
        Integer deviceScreenHeight = MetadataHelper.valueFromStaticDevicesInfo("screenHeight", this.deviceName().toLowerCase());
        if (deviceScreenHeight == 0) {
            deviceScreenHeight = ((Long)this.getViewportRect().get("height")).intValue() + this.statBarHeight();
        }
        return deviceScreenHeight;
    }

    @Override
    public Integer statBarHeight() {
        Integer statBar = this.getStatusBar();
        if (statBar != null) {
            return statBar;
        }
        Integer statBarHeight = MetadataHelper.valueFromStaticDevicesInfo("statusBarHeight", this.deviceName().toLowerCase());
        Integer pixelRatio = MetadataHelper.valueFromStaticDevicesInfo("pixelRatio", this.deviceName().toLowerCase());
        if (statBarHeight == 0) {
            return ((Long)this.getViewportRect().get("top")).intValue();
        }
        return statBarHeight * pixelRatio;
    }

    private Map getViewportRect() {
        if (Cache.CACHE_MAP.get("viewportRect_" + this.sessionId) == null) {
            try {
                Cache.CACHE_MAP.put("viewportRect_" + this.sessionId, this.getSession().get("viewportRect"));
            }
            catch (NoSuchMethodError e) {
                Cache.CACHE_MAP.put("viewportRect_" + this.sessionId, this.driver.getSessionDetails().get("viewportRect"));
            }
        }
        return (Map)Cache.CACHE_MAP.get("viewportRect_" + this.sessionId);
    }

    private Map getSession() {
        this.driver.addCommand(HttpMethod.GET, "/session/" + this.driver.getSessionId(), "getSession");
        Response session = this.driver.execute("getSession");
        return (Map)session.getValue();
    }

    @Override
    public Integer navBarHeight() {
        Integer navBar = this.getNavBar();
        if (navBar != null) {
            return navBar;
        }
        return 0;
    }

    @Override
    public Integer scaleFactor() {
        return Integer.valueOf(this.driver.getSessionDetails().get("pixelRatio").toString());
    }
}

