/*
 * Decompiled with CFR 0.152.
 */
package io.percy.appium.lib;

import io.appium.java_client.AppiumDriver;
import io.percy.appium.AppPercy;
import io.percy.appium.lib.Cache;
import java.util.Map;

public class PercyOptions {
    private AppiumDriver driver;
    private String sessionId;

    public PercyOptions(AppiumDriver driver) {
        this.driver = driver;
        this.sessionId = driver.getSessionId().toString();
    }

    public Boolean percyOptionEnabled() {
        Map percyOptionsW3CProtocol = this.getPercyOptions();
        Object percyEnabledJsonProtocol = this.driver.getCapabilities().getCapability("percy.enabled");
        if (percyOptionsW3CProtocol == null && percyEnabledJsonProtocol == null) {
            AppPercy.log("Percy options not provided in capabilitiies, considering enabled", "debug");
            return true;
        }
        if (percyEnabledJsonProtocol != null && percyEnabledJsonProtocol.toString() == "false" || percyOptionsW3CProtocol != null && percyOptionsW3CProtocol.get("enabled").toString() == "false") {
            AppPercy.log("App Percy is disabled in capabilities");
            return false;
        }
        return true;
    }

    public Boolean setPercyIgnoreErrors() {
        Map percyOptionsW3CProtocol = this.getPercyOptions();
        Object percyIgnoreErrorsJsonProtocol = this.driver.getCapabilities().getCapability("percy.ignoreErrors");
        if (percyOptionsW3CProtocol == null && percyIgnoreErrorsJsonProtocol == null) {
            AppPercy.log("Percy options not provided in capabilitiies, ignoring errors by default", "debug");
            return true;
        }
        if (percyIgnoreErrorsJsonProtocol != null && percyIgnoreErrorsJsonProtocol.toString() == "false" || percyOptionsW3CProtocol != null && percyOptionsW3CProtocol.get("ignoreErrors").toString() == "false") {
            return false;
        }
        return true;
    }

    private Map getPercyOptions() {
        if (Cache.CACHE_MAP.get("percyOptions_" + this.sessionId) == null) {
            Cache.CACHE_MAP.put("percyOptions_" + this.sessionId, this.driver.getCapabilities().getCapability("percyOptions"));
        }
        return (Map)Cache.CACHE_MAP.get("percyOptions_" + this.sessionId);
    }
}

