/*
 * Decompiled with CFR 0.152.
 */
package io.percy.appium;

import io.appium.java_client.AppiumDriver;
import io.appium.java_client.MobileElement;
import io.percy.appium.AppPercy;
import io.percy.appium.IPercy;
import io.percy.appium.lib.CliWrapper;
import io.percy.appium.lib.PercyOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PercyOnAutomate
extends IPercy {
    private final AppiumDriver driver;
    private CliWrapper cliWrapper;
    private final PercyOptions percyOptions;
    private Boolean isPercyEnabled = null;
    private static Boolean ignoreErrors = true;

    public PercyOnAutomate(AppiumDriver driver) {
        this.driver = driver;
        this.cliWrapper = new CliWrapper(driver);
        this.percyOptions = new PercyOptions(driver);
        ignoreErrors = this.percyOptions.setPercyIgnoreErrors();
    }

    @Override
    public void screenshot(String name) {
        this.screenshot(name, (Map<String, Object>)null);
    }

    @Override
    public void screenshot(String name, Map<String, Object> options) {
        block5: {
            try {
                if (this.isPercyEnabled == null) {
                    this.isPercyEnabled = this.cliWrapper.healthcheck();
                }
                if (!this.isPercyEnabled.booleanValue() || !this.percyOptions.percyOptionEnabled().booleanValue()) {
                    return;
                }
                String sessionId = this.driver.getSessionId().toString();
                String remoteWebAddress = this.driver.getRemoteAddress().toString();
                Map capabilities = this.driver.getCapabilities().asMap();
                String ignoreElementKey = "ignore_region_appium_elements";
                if (options != null && options.containsKey(ignoreElementKey)) {
                    List<String> ignoreElementIds = this.getElementIdFromElement((List)options.get(ignoreElementKey));
                    options.remove(ignoreElementKey);
                    options.put("ignore_region_elements", ignoreElementIds);
                }
                this.cliWrapper.postScreenshotPOA(name, sessionId, remoteWebAddress, capabilities, options);
            }
            catch (Exception e) {
                AppPercy.log("Error taking screenshot " + name);
                AppPercy.log(e.toString());
                if (ignoreErrors.booleanValue()) break block5;
                throw new RuntimeException("Error taking screenshot " + name, e);
            }
        }
    }

    private List<String> getElementIdFromElement(List<MobileElement> elements) {
        ArrayList<String> ignoredElementsArray = new ArrayList<String>();
        for (MobileElement element : elements) {
            String elementId = element.getId();
            ignoredElementsArray.add(elementId);
        }
        return ignoredElementsArray;
    }

    protected void setCliWrapper(CliWrapper cli) {
        this.cliWrapper = cli;
    }
}

