/*
 * Decompiled with CFR 0.152.
 */
package io.percy.appium;

import io.appium.java_client.AppiumDriver;
import io.percy.appium.lib.Cache;
import io.percy.appium.lib.CliWrapper;
import io.percy.appium.lib.PercyOptions;
import io.percy.appium.lib.ScreenshotOptions;
import io.percy.appium.providers.GenericProvider;
import io.percy.appium.providers.ProviderResolver;
import java.util.HashSet;

public class AppPercy {
    private AppiumDriver driver;
    private CliWrapper cliWrapper;
    private PercyOptions percyOptions;
    private static boolean PERCY_DEBUG = System.getenv().getOrDefault("PERCY_LOGLEVEL", "info").equals("debug");
    private static String LABEL = "[\u001b[35m" + (PERCY_DEBUG ? "percy:java" : "percy") + "\u001b[39m]";
    private boolean isPercyEnabled;
    private String sessionId;
    private static Boolean ignoreErrors = true;

    public AppPercy(AppiumDriver driver) {
        this.driver = driver;
        this.cliWrapper = new CliWrapper(driver);
        this.percyOptions = new PercyOptions(driver);
        this.isPercyEnabled = this.cliWrapper.healthcheck();
        this.sessionId = driver.getSessionId().toString();
    }

    public void screenshot(String name) {
        this.screenshot(name, false, null);
    }

    public void screenshot(String name, Boolean fullScreen) {
        this.screenshot(name, fullScreen, null);
    }

    public void screenshot(String name, ScreenshotOptions options) {
        this.screenshot(name, false, options);
    }

    public void screenshot(String name, Boolean fullScreen, ScreenshotOptions options) {
        block4: {
            if (!this.isPercyEnabled || !this.percyOptions.percyOptionEnabled().booleanValue()) {
                return;
            }
            this.percyOptions.setPercyIgnoreErrors();
            try {
                GenericProvider provider = ProviderResolver.resolveProvider(this.driver);
                if (options == null) {
                    options = new ScreenshotOptions();
                }
                options.setFullScreen(fullScreen);
                provider.screenshot(name, options);
            }
            catch (Exception e) {
                AppPercy.log("Error taking screenshot " + name);
                AppPercy.log(e.toString());
                if (ignoreErrors.booleanValue()) break block4;
                throw new RuntimeException("Error taking screenshot " + name, e);
            }
        }
    }

    protected void finalize() throws Throwable {
        HashSet<String> set = new HashSet<String>();
        set.add("percyOptions_" + this.sessionId);
        set.add("viewportRect_" + this.sessionId);
        set.add("getDevicesJson");
        Cache.CACHE_MAP.keySet().removeAll(set);
    }

    public static void log(String message) {
        AppPercy.log(message, "info");
    }

    public static void log(String message, String logLevel) {
        if (logLevel == "debug" && PERCY_DEBUG) {
            System.out.println(LABEL + " [\u001b[35m" + message + "\u001b[91m]");
        } else if (logLevel == "info") {
            System.out.println(LABEL + " " + message);
        } else if (logLevel == "warn") {
            System.out.println(LABEL + " [\u001b[35m" + message + "\u001b[93m]");
        }
    }
}

