/*
 * Decompiled with CFR 0.152.
 */
package io.percy.appium.metadata;

import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidDriver;
import io.percy.appium.lib.Cache;
import io.percy.appium.metadata.Metadata;
import java.util.Map;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpMethod;

public class AndroidMetadata
extends Metadata {
    private AndroidDriver driver;
    private String sessionId;

    public AndroidMetadata(AppiumDriver driver, String deviceName, Integer statusBar, Integer navBar, String orientation, String platformVersion) {
        super(driver, deviceName, statusBar, navBar, orientation, platformVersion);
        this.driver = (AndroidDriver)driver;
        this.sessionId = driver.getSessionId().toString();
    }

    @Override
    public String deviceName() {
        String deviceName = this.getDeviceName();
        if (deviceName != null) {
            return deviceName;
        }
        Object device = this.driver.getCapabilities().getCapability("device");
        if (device == null) {
            Map desiredCaps = (Map)this.driver.getCapabilities().getCapability("desired");
            device = desiredCaps.get("deviceName");
        }
        return device.toString();
    }

    @Override
    public Integer deviceScreenWidth() {
        return Integer.parseInt(this.driver.getCapabilities().getCapability("deviceScreenSize").toString().split("x")[0]);
    }

    @Override
    public Integer deviceScreenHeight() {
        return Integer.parseInt(this.driver.getCapabilities().getCapability("deviceScreenSize").toString().split("x")[1]);
    }

    @Override
    public Integer statBarHeight() {
        Integer statBar = this.getStatusBar();
        if (statBar != null) {
            return statBar;
        }
        return ((Long)this.getViewportRect().get("top")).intValue();
    }

    @Override
    public Integer navBarHeight() {
        Integer navBar = this.getNavBar();
        if (navBar != null) {
            return navBar;
        }
        Integer fullDeviceScreenHeight = this.deviceScreenHeight();
        Integer deviceScreenHeight = ((Long)this.getViewportRect().get("height")).intValue();
        return fullDeviceScreenHeight - (deviceScreenHeight + this.statBarHeight());
    }

    private Map getViewportRect() {
        if (Cache.CACHE_MAP.get("viewportRect_" + this.sessionId) == null) {
            try {
                Cache.CACHE_MAP.put("viewportRect_" + this.sessionId, this.getSession().get("viewportRect"));
            }
            catch (NoSuchMethodError e) {
                Cache.CACHE_MAP.put("viewportRect_" + this.sessionId, this.driver.getSessionDetails().get("viewportRect"));
            }
        }
        return (Map)Cache.CACHE_MAP.get("viewportRect_" + this.sessionId);
    }

    private Map getSession() {
        this.driver.addCommand(HttpMethod.GET, "/session/" + this.driver.getSessionId(), "getSession");
        Response session = this.driver.execute("getSession");
        return (Map)session.getValue();
    }

    @Override
    public Integer scaleFactor() {
        return 1;
    }
}

