/*
 * Decompiled with CFR 0.152.
 */
package io.pdfire.client;

import com.github.kittinunf.fuel.Fuel;
import com.github.kittinunf.fuel.core.Request;
import com.github.kittinunf.fuel.core.RequestFactory;
import com.github.kittinunf.fuel.core.Response;
import com.google.gson.Gson;
import io.pdfire.client.ApiError;
import io.pdfire.client.BadRequestException;
import io.pdfire.client.BytesResult;
import io.pdfire.client.Conversion;
import io.pdfire.client.ConversionException;
import io.pdfire.client.ConversionParameters;
import io.pdfire.client.ErrorResponse;
import io.pdfire.client.Parameters;
import io.pdfire.client.QuotaException;
import io.pdfire.client.RequestException;
import io.pdfire.client.Result;
import io.pdfire.client.StorageParameter;
import io.pdfire.client.UnauthorizedException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00032\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00032\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0010J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rJ&\u0010\u0017\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0016\b\u0002\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0019J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"H\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/pdfire/client/Client;", "", "apiKey", "", "(Ljava/lang/String;)V", "getApiKey", "()Ljava/lang/String;", "setApiKey", "gson", "Lcom/google/gson/Gson;", "convert", "Lio/pdfire/client/Result;", "params", "Lio/pdfire/client/Parameters;", "convertHTML", "html", "Lio/pdfire/client/ConversionParameters;", "convertToByteArray", "", "convertURL", "url", "convertUsingCDN", "Lio/pdfire/client/Conversion;", "convertUsingStorage", "configure", "Lkotlin/Function1;", "Lio/pdfire/client/StorageParameter;", "", "getApiErrors", "", "Lio/pdfire/client/ApiError;", "body", "makeResult", "response", "Lcom/github/kittinunf/fuel/core/Response;", "Companion", "pdfire-client"})
public final class Client {
    private final Gson gson;
    @NotNull
    private String apiKey;
    @NotNull
    private static final String baseUrl = "https://api.pdfire.io/v1";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Result convert(@NotNull Parameters params) {
        void response;
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        String body = this.gson.toJson(params.toMap());
        Request request = RequestFactory.Convenience.DefaultImpls.post$default((RequestFactory.Convenience)Fuel.INSTANCE, (String)(baseUrl + "/conversions"), null, (int)2, null).header("Content-Type", (Object)"application/json");
        String string = body;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"body");
        Triple triple = Request.DefaultImpls.body$default((Request)request, (String)string, null, (int)2, null).response();
        Response response2 = (Response)triple.component2();
        com.github.kittinunf.result.Result result = (com.github.kittinunf.result.Result)triple.component3();
        switch (response.getStatusCode()) {
            case 400: {
                throw (Throwable)new BadRequestException(this.getApiErrors((byte[])result.get()));
            }
            case 401: {
                throw (Throwable)new UnauthorizedException(this.getApiErrors((byte[])result.get()));
            }
            case 402: {
                throw (Throwable)new QuotaException(this.getApiErrors((byte[])result.get()));
            }
            case 500: {
                throw (Throwable)new ConversionException(this.getApiErrors((byte[])result.get()));
            }
            case 201: {
                return this.makeResult((Response)response);
            }
        }
        throw (Throwable)new RequestException(this.getApiErrors((byte[])result.get()), "Unknown error.");
    }

    @NotNull
    public final Result convertURL(@NotNull String url, @Nullable ConversionParameters params) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        ConversionParameters conversionParameters = params;
        if (conversionParameters == null) {
            conversionParameters = new ConversionParameters(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -1, 7, null);
        }
        ConversionParameters p = conversionParameters;
        p.setUrl(url);
        return this.convert(p);
    }

    public static /* synthetic */ Result convertURL$default(Client client, String string, ConversionParameters conversionParameters, int n, Object object) {
        if ((n & 2) != 0) {
            conversionParameters = null;
        }
        return client.convertURL(string, conversionParameters);
    }

    @NotNull
    public final Result convertHTML(@NotNull String html, @Nullable ConversionParameters params) {
        Intrinsics.checkParameterIsNotNull((Object)html, (String)"html");
        ConversionParameters conversionParameters = params;
        if (conversionParameters == null) {
            conversionParameters = new ConversionParameters(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -1, 7, null);
        }
        ConversionParameters p = conversionParameters;
        p.setHtml(html);
        return this.convert(p);
    }

    public static /* synthetic */ Result convertHTML$default(Client client, String string, ConversionParameters conversionParameters, int n, Object object) {
        if ((n & 2) != 0) {
            conversionParameters = null;
        }
        return client.convertHTML(string, conversionParameters);
    }

    @NotNull
    public final byte[] convertToByteArray(@NotNull Parameters params) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        params.setCdn(false);
        params.setStorage(null);
        return this.convert(params).getBytes();
    }

    @NotNull
    public final Conversion convertUsingCDN(@NotNull Parameters params) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        params.setCdn(true);
        Result result = this.convert(params);
        if (result == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.pdfire.client.Conversion");
        }
        return (Conversion)result;
    }

    @NotNull
    public final Conversion convertUsingStorage(@NotNull Parameters params, @Nullable Function1<? super StorageParameter, Unit> configure) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        StorageParameter storage = new StorageParameter(null, null, 3, null);
        if (configure != null) {
            configure.invoke((Object)storage);
        }
        params.setStorage(storage);
        Result result = this.convert(params);
        if (result == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.pdfire.client.Conversion");
        }
        return (Conversion)result;
    }

    public static /* synthetic */ Conversion convertUsingStorage$default(Client client, Parameters parameters, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return client.convertUsingStorage(parameters, (Function1<? super StorageParameter, Unit>)function1);
    }

    private final List<ApiError> getApiErrors(byte[] body) {
        return ((ErrorResponse)this.gson.fromJson(body.toString(), ErrorResponse.class)).getErrors();
    }

    private final Result makeResult(Response response) {
        Result result;
        Collection $this$toTypedArray$iv = (Collection)response.getHeaders().get((Object)"Content-Type");
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] contentTypes = stringArray;
        Object object = contentTypes;
        boolean bl = false;
        String[] stringArray2 = object;
        boolean bl2 = false;
        object = !(stringArray2.length == 0) ? contentTypes[0] : "application/octet-stream";
        switch (((String)object).hashCode()) {
            case -43840953: {
                if (((String)object).equals("application/json")) {
                    Object object2 = new Gson().fromJson(response.body().toString(), Conversion.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"Gson().fromJson(response\u2026, Conversion::class.java)");
                    result = (Result)object2;
                    break;
                }
            }
            default: {
                result = new BytesResult(response.body().toByteArray());
            }
        }
        return result;
    }

    @NotNull
    public final String getApiKey() {
        return this.apiKey;
    }

    public final void setApiKey(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.apiKey = string;
    }

    public Client(@NotNull String apiKey) {
        Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
        this.apiKey = apiKey;
        this.gson = new Gson();
    }

    static {
        baseUrl = baseUrl;
    }

    @NotNull
    public static final String getBaseUrl() {
        Companion companion = Companion;
        return baseUrl;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/pdfire/client/Client$Companion;", "", "()V", "baseUrl", "", "baseUrl$annotations", "getBaseUrl", "()Ljava/lang/String;", "pdfire-client"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void baseUrl$annotations() {
        }

        @NotNull
        public final String getBaseUrl() {
            return baseUrl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

